// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.security_and_compliance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class PolicyLogItem {
    /**
     * 用户ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 用户名
     * <p> 示例值：张三
     */
    @SerializedName("user_name")
    private String userName;
    /**
     * 操作
     * <p> 示例值：Access
     */
    @SerializedName("action")
    private String action;
    /**
     * 场景
     * <p> 示例值：飞书
     */
    @SerializedName("resource")
    private String resource;
    /**
     * 命中时间
     * <p> 示例值：1668700799000
     */
    @SerializedName("event_time")
    private String eventTime;
    /**
     * 条件
     * <p> 示例值：{\"DEVICE_OWNERSHIP\":\"Unknown\",\"DEVICE_TERMINAL\":\"Web\",\"LSA_CLIENT_BIND_STATUS\":\"Unknown\",\"USER_ID\":7564320266201861655,\"DEVICE_CREDIBILITY\":\"Unknown\",\"DEVICE_OS\":\"macOS\"}
     */
    @SerializedName("condition")
    private String condition;
    /**
     * 策略信息
     * <p> 示例值：
     */
    @SerializedName("policy_infos")
    private PolicyEntity[] policyInfos;
    /**
     * 系统执行动作
     * <p> 示例值：DENY_WITHOUT_APPROVAL
     */
    @SerializedName("system_action")
    private String systemAction;

    // builder 开始
    public PolicyLogItem() {
    }

    public PolicyLogItem(Builder builder) {
        /**
         * 用户ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 用户名
         * <p> 示例值：张三
         */
        this.userName = builder.userName;
        /**
         * 操作
         * <p> 示例值：Access
         */
        this.action = builder.action;
        /**
         * 场景
         * <p> 示例值：飞书
         */
        this.resource = builder.resource;
        /**
         * 命中时间
         * <p> 示例值：1668700799000
         */
        this.eventTime = builder.eventTime;
        /**
         * 条件
         * <p> 示例值：{\"DEVICE_OWNERSHIP\":\"Unknown\",\"DEVICE_TERMINAL\":\"Web\",\"LSA_CLIENT_BIND_STATUS\":\"Unknown\",\"USER_ID\":7564320266201861655,\"DEVICE_CREDIBILITY\":\"Unknown\",\"DEVICE_OS\":\"macOS\"}
         */
        this.condition = builder.condition;
        /**
         * 策略信息
         * <p> 示例值：
         */
        this.policyInfos = builder.policyInfos;
        /**
         * 系统执行动作
         * <p> 示例值：DENY_WITHOUT_APPROVAL
         */
        this.systemAction = builder.systemAction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public PolicyEntity[] getPolicyInfos() {
        return this.policyInfos;
    }

    public void setPolicyInfos(PolicyEntity[] policyInfos) {
        this.policyInfos = policyInfos;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public void setSystemAction(String systemAction) {
        this.systemAction = systemAction;
    }

    public static class Builder {
        /**
         * 用户ID
         * <p> 示例值：
         */
        private String userId;
        /**
         * 用户名
         * <p> 示例值：张三
         */
        private String userName;
        /**
         * 操作
         * <p> 示例值：Access
         */
        private String action;
        /**
         * 场景
         * <p> 示例值：飞书
         */
        private String resource;
        /**
         * 命中时间
         * <p> 示例值：1668700799000
         */
        private String eventTime;
        /**
         * 条件
         * <p> 示例值：{\"DEVICE_OWNERSHIP\":\"Unknown\",\"DEVICE_TERMINAL\":\"Web\",\"LSA_CLIENT_BIND_STATUS\":\"Unknown\",\"USER_ID\":7564320266201861655,\"DEVICE_CREDIBILITY\":\"Unknown\",\"DEVICE_OS\":\"macOS\"}
         */
        private String condition;
        /**
         * 策略信息
         * <p> 示例值：
         */
        private PolicyEntity[] policyInfos;
        /**
         * 系统执行动作
         * <p> 示例值：DENY_WITHOUT_APPROVAL
         */
        private String systemAction;

        /**
         * 用户ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 用户名
         * <p> 示例值：张三
         *
         * @param userName
         * @return
         */
        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }


        /**
         * 操作
         * <p> 示例值：Access
         *
         * @param action
         * @return
         */
        public Builder action(String action) {
            this.action = action;
            return this;
        }


        /**
         * 场景
         * <p> 示例值：飞书
         *
         * @param resource
         * @return
         */
        public Builder resource(String resource) {
            this.resource = resource;
            return this;
        }


        /**
         * 命中时间
         * <p> 示例值：1668700799000
         *
         * @param eventTime
         * @return
         */
        public Builder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }


        /**
         * 条件
         * <p> 示例值：{\"DEVICE_OWNERSHIP\":\"Unknown\",\"DEVICE_TERMINAL\":\"Web\",\"LSA_CLIENT_BIND_STATUS\":\"Unknown\",\"USER_ID\":7564320266201861655,\"DEVICE_CREDIBILITY\":\"Unknown\",\"DEVICE_OS\":\"macOS\"}
         *
         * @param condition
         * @return
         */
        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }


        /**
         * 策略信息
         * <p> 示例值：
         *
         * @param policyInfos
         * @return
         */
        public Builder policyInfos(PolicyEntity[] policyInfos) {
            this.policyInfos = policyInfos;
            return this;
        }


        /**
         * 系统执行动作
         * <p> 示例值：DENY_WITHOUT_APPROVAL
         *
         * @param systemAction
         * @return
         */
        public Builder systemAction(String systemAction) {
            this.systemAction = systemAction;
            return this;
        }


        public PolicyLogItem build() {
            return new PolicyLogItem(this);
        }
    }
}
