// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.aily.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.aily.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class AilyKnowledgeAskProcessData {
    /**
     * 有数据分析时，根据数据生成的图表描述，按markdown语义描述
     * <p> 示例值：
     */
    @SerializedName("chart_dsls")
    private String[] chartDsls;
    /**
     * 召回的知识视图切片的文本数据
     * <p> 示例值：
     */
    @SerializedName("chunks")
    private String[] chunks;
    /**
     * 有数据分析时，查询到数据结果，每个元素为 json 序列化后的数据结果
     * <p> 示例值：
     */
    @SerializedName("sql_data")
    private String[] sqlData;

    // builder 开始
    public AilyKnowledgeAskProcessData() {
    }

    public AilyKnowledgeAskProcessData(Builder builder) {
        /**
         * 有数据分析时，根据数据生成的图表描述，按markdown语义描述
         * <p> 示例值：
         */
        this.chartDsls = builder.chartDsls;
        /**
         * 召回的知识视图切片的文本数据
         * <p> 示例值：
         */
        this.chunks = builder.chunks;
        /**
         * 有数据分析时，查询到数据结果，每个元素为 json 序列化后的数据结果
         * <p> 示例值：
         */
        this.sqlData = builder.sqlData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String[] getChartDsls() {
        return this.chartDsls;
    }

    public void setChartDsls(String[] chartDsls) {
        this.chartDsls = chartDsls;
    }

    public String[] getChunks() {
        return this.chunks;
    }

    public void setChunks(String[] chunks) {
        this.chunks = chunks;
    }

    public String[] getSqlData() {
        return this.sqlData;
    }

    public void setSqlData(String[] sqlData) {
        this.sqlData = sqlData;
    }

    public static class Builder {
        /**
         * 有数据分析时，根据数据生成的图表描述，按markdown语义描述
         * <p> 示例值：
         */
        private String[] chartDsls;
        /**
         * 召回的知识视图切片的文本数据
         * <p> 示例值：
         */
        private String[] chunks;
        /**
         * 有数据分析时，查询到数据结果，每个元素为 json 序列化后的数据结果
         * <p> 示例值：
         */
        private String[] sqlData;

        /**
         * 有数据分析时，根据数据生成的图表描述，按markdown语义描述
         * <p> 示例值：
         *
         * @param chartDsls
         * @return
         */
        public Builder chartDsls(String[] chartDsls) {
            this.chartDsls = chartDsls;
            return this;
        }


        /**
         * 召回的知识视图切片的文本数据
         * <p> 示例值：
         *
         * @param chunks
         * @return
         */
        public Builder chunks(String[] chunks) {
            this.chunks = chunks;
            return this;
        }


        /**
         * 有数据分析时，查询到数据结果，每个元素为 json 序列化后的数据结果
         * <p> 示例值：
         *
         * @param sqlData
         * @return
         */
        public Builder sqlData(String[] sqlData) {
            this.sqlData = sqlData;
            return this;
        }


        public AilyKnowledgeAskProcessData build() {
            return new AilyKnowledgeAskProcessData(this);
        }
    }
}
