// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.application.v6.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class NavigateMeta {
    /**
     * 主导航小程序版本号
     * <p> 示例值：1.0.0
     */
    @SerializedName("version")
    private String version;
    /**
     * 默认图片 url
     * <p> 示例值：https://www.example.com
     */
    @SerializedName("image_url")
    private String imageUrl;
    /**
     * 选中态图片 url
     * <p> 示例值：https://www.example.com
     */
    @SerializedName("hover_image_url")
    private String hoverImageUrl;

    // builder 开始
    public NavigateMeta() {
    }

    public NavigateMeta(Builder builder) {
        /**
         * 主导航小程序版本号
         * <p> 示例值：1.0.0
         */
        this.version = builder.version;
        /**
         * 默认图片 url
         * <p> 示例值：https://www.example.com
         */
        this.imageUrl = builder.imageUrl;
        /**
         * 选中态图片 url
         * <p> 示例值：https://www.example.com
         */
        this.hoverImageUrl = builder.hoverImageUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getHoverImageUrl() {
        return this.hoverImageUrl;
    }

    public void setHoverImageUrl(String hoverImageUrl) {
        this.hoverImageUrl = hoverImageUrl;
    }

    public static class Builder {
        /**
         * 主导航小程序版本号
         * <p> 示例值：1.0.0
         */
        private String version;
        /**
         * 默认图片 url
         * <p> 示例值：https://www.example.com
         */
        private String imageUrl;
        /**
         * 选中态图片 url
         * <p> 示例值：https://www.example.com
         */
        private String hoverImageUrl;

        /**
         * 主导航小程序版本号
         * <p> 示例值：1.0.0
         *
         * @param version
         * @return
         */
        public Builder version(String version) {
            this.version = version;
            return this;
        }


        /**
         * 默认图片 url
         * <p> 示例值：https://www.example.com
         *
         * @param imageUrl
         * @return
         */
        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }


        /**
         * 选中态图片 url
         * <p> 示例值：https://www.example.com
         *
         * @param hoverImageUrl
         * @return
         */
        public Builder hoverImageUrl(String hoverImageUrl) {
            this.hoverImageUrl = hoverImageUrl;
            return this;
        }


        public NavigateMeta build() {
            return new NavigateMeta(this);
        }
    }
}
