// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.compensation.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.compensation.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class LumpSumPaymentForUpdate {
    /**
     * 一次性支付记录id
     * <p> 示例值：7397033607132351532
     */
    @SerializedName("id")
    private String id;
    /**
     * 总金额，字符串表达的数字
     * <p> 示例值：2000.00
     */
    @SerializedName("total_amount")
    private String totalAmount;
    /**
     * 绑定期，单位为月
     * <p> 示例值：2
     */
    @SerializedName("binding_period")
    private Integer bindingPeriod;
    /**
     * 币种id
     * <p> 示例值：6863329932261459464
     */
    @SerializedName("currency_id")
    private String currencyId;
    /**
     * 发放次数，必须与details的长度一致
     * <p> 示例值：3
     */
    @SerializedName("issuance_frequency")
    private Integer issuanceFrequency;
    /**
     * 备注
     * <p> 示例值：备注
     */
    @SerializedName("remark")
    private String remark;
    /**
     * 发放明细列表
     * <p> 示例值：
     */
    @SerializedName("details")
    private LumpSumPaymentDetailForUpdate[] details;

    // builder 开始
    public LumpSumPaymentForUpdate() {
    }

    public LumpSumPaymentForUpdate(Builder builder) {
        /**
         * 一次性支付记录id
         * <p> 示例值：7397033607132351532
         */
        this.id = builder.id;
        /**
         * 总金额，字符串表达的数字
         * <p> 示例值：2000.00
         */
        this.totalAmount = builder.totalAmount;
        /**
         * 绑定期，单位为月
         * <p> 示例值：2
         */
        this.bindingPeriod = builder.bindingPeriod;
        /**
         * 币种id
         * <p> 示例值：6863329932261459464
         */
        this.currencyId = builder.currencyId;
        /**
         * 发放次数，必须与details的长度一致
         * <p> 示例值：3
         */
        this.issuanceFrequency = builder.issuanceFrequency;
        /**
         * 备注
         * <p> 示例值：备注
         */
        this.remark = builder.remark;
        /**
         * 发放明细列表
         * <p> 示例值：
         */
        this.details = builder.details;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getBindingPeriod() {
        return this.bindingPeriod;
    }

    public void setBindingPeriod(Integer bindingPeriod) {
        this.bindingPeriod = bindingPeriod;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Integer getIssuanceFrequency() {
        return this.issuanceFrequency;
    }

    public void setIssuanceFrequency(Integer issuanceFrequency) {
        this.issuanceFrequency = issuanceFrequency;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public LumpSumPaymentDetailForUpdate[] getDetails() {
        return this.details;
    }

    public void setDetails(LumpSumPaymentDetailForUpdate[] details) {
        this.details = details;
    }

    public static class Builder {
        /**
         * 一次性支付记录id
         * <p> 示例值：7397033607132351532
         */
        private String id;
        /**
         * 总金额，字符串表达的数字
         * <p> 示例值：2000.00
         */
        private String totalAmount;
        /**
         * 绑定期，单位为月
         * <p> 示例值：2
         */
        private Integer bindingPeriod;
        /**
         * 币种id
         * <p> 示例值：6863329932261459464
         */
        private String currencyId;
        /**
         * 发放次数，必须与details的长度一致
         * <p> 示例值：3
         */
        private Integer issuanceFrequency;
        /**
         * 备注
         * <p> 示例值：备注
         */
        private String remark;
        /**
         * 发放明细列表
         * <p> 示例值：
         */
        private LumpSumPaymentDetailForUpdate[] details;

        /**
         * 一次性支付记录id
         * <p> 示例值：7397033607132351532
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 总金额，字符串表达的数字
         * <p> 示例值：2000.00
         *
         * @param totalAmount
         * @return
         */
        public Builder totalAmount(String totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }


        /**
         * 绑定期，单位为月
         * <p> 示例值：2
         *
         * @param bindingPeriod
         * @return
         */
        public Builder bindingPeriod(Integer bindingPeriod) {
            this.bindingPeriod = bindingPeriod;
            return this;
        }


        /**
         * 币种id
         * <p> 示例值：6863329932261459464
         *
         * @param currencyId
         * @return
         */
        public Builder currencyId(String currencyId) {
            this.currencyId = currencyId;
            return this;
        }


        /**
         * 发放次数，必须与details的长度一致
         * <p> 示例值：3
         *
         * @param issuanceFrequency
         * @return
         */
        public Builder issuanceFrequency(Integer issuanceFrequency) {
            this.issuanceFrequency = issuanceFrequency;
            return this;
        }


        /**
         * 备注
         * <p> 示例值：备注
         *
         * @param remark
         * @return
         */
        public Builder remark(String remark) {
            this.remark = remark;
            return this;
        }


        /**
         * 发放明细列表
         * <p> 示例值：
         *
         * @param details
         * @return
         */
        public Builder details(LumpSumPaymentDetailForUpdate[] details) {
            this.details = details;
            return this;
        }


        public LumpSumPaymentForUpdate build() {
            return new LumpSumPaymentForUpdate(this);
        }
    }
}
