// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class EmployeeV2 {
    /**
     * 员工 ID
     * <p> 示例值：123
     */
    @SerializedName("id")
    private String id;
    /**
     * 投递 ID
     * <p> 示例值：123
     */
    @SerializedName("application_id")
    private String applicationId;
    /**
     * 入职状态
     * <p> 示例值：1
     */
    @SerializedName("onboard_status")
    private Integer onboardStatus;
    /**
     * 转正状态
     * <p> 示例值：1
     */
    @SerializedName("conversion_status")
    private Integer conversionStatus;
    /**
     * 实际入职时间
     * <p> 示例值：1637596800000
     */
    @SerializedName("onboard_time")
    private String onboardTime;
    /**
     * 预期转正时间
     * <p> 示例值：1637596800000
     */
    @SerializedName("expected_conversion_time")
    private String expectedConversionTime;
    /**
     * 实际转正时间
     * <p> 示例值：1637596800000
     */
    @SerializedName("actual_conversion_time")
    private String actualConversionTime;
    /**
     * 离职时间
     * <p> 示例值：1637596800000
     */
    @SerializedName("overboard_time")
    private String overboardTime;
    /**
     * 离职原因
     * <p> 示例值：职业发展考虑
     */
    @SerializedName("overboard_note")
    private String overboardNote;
    /**
     * 办公地点
     * <p> 示例值：C20
     */
    @SerializedName("onboard_city_code")
    private String onboardCityCode;
    /**
     * 入职部门 ID
     * <p> 示例值：6966123381141866028
     */
    @SerializedName("department_id")
    private String departmentId;
    /**
     * 直属上级 ID
     * <p> 示例值：ou-xxx
     */
    @SerializedName("leader_id")
    private String leaderId;
    /**
     * 序列 ID
     * <p> 示例值：6501
     */
    @SerializedName("sequence_id")
    private String sequenceId;
    /**
     * 职级 ID
     * <p> 示例值：6301
     */
    @SerializedName("level_id")
    private String levelId;
    /**
     * 员工类型
     * <p> 示例值：1
     */
    @SerializedName("employee_type")
    private String employeeType;
    /**
     * 招聘需求ID
     * <p> 示例值：123123123213
     */
    @SerializedName("job_requirement_id")
    private String jobRequirementId;

    // builder 开始
    public EmployeeV2() {
    }

    public EmployeeV2(Builder builder) {
        /**
         * 员工 ID
         * <p> 示例值：123
         */
        this.id = builder.id;
        /**
         * 投递 ID
         * <p> 示例值：123
         */
        this.applicationId = builder.applicationId;
        /**
         * 入职状态
         * <p> 示例值：1
         */
        this.onboardStatus = builder.onboardStatus;
        /**
         * 转正状态
         * <p> 示例值：1
         */
        this.conversionStatus = builder.conversionStatus;
        /**
         * 实际入职时间
         * <p> 示例值：1637596800000
         */
        this.onboardTime = builder.onboardTime;
        /**
         * 预期转正时间
         * <p> 示例值：1637596800000
         */
        this.expectedConversionTime = builder.expectedConversionTime;
        /**
         * 实际转正时间
         * <p> 示例值：1637596800000
         */
        this.actualConversionTime = builder.actualConversionTime;
        /**
         * 离职时间
         * <p> 示例值：1637596800000
         */
        this.overboardTime = builder.overboardTime;
        /**
         * 离职原因
         * <p> 示例值：职业发展考虑
         */
        this.overboardNote = builder.overboardNote;
        /**
         * 办公地点
         * <p> 示例值：C20
         */
        this.onboardCityCode = builder.onboardCityCode;
        /**
         * 入职部门 ID
         * <p> 示例值：6966123381141866028
         */
        this.departmentId = builder.departmentId;
        /**
         * 直属上级 ID
         * <p> 示例值：ou-xxx
         */
        this.leaderId = builder.leaderId;
        /**
         * 序列 ID
         * <p> 示例值：6501
         */
        this.sequenceId = builder.sequenceId;
        /**
         * 职级 ID
         * <p> 示例值：6301
         */
        this.levelId = builder.levelId;
        /**
         * 员工类型
         * <p> 示例值：1
         */
        this.employeeType = builder.employeeType;
        /**
         * 招聘需求ID
         * <p> 示例值：123123123213
         */
        this.jobRequirementId = builder.jobRequirementId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Integer getOnboardStatus() {
        return this.onboardStatus;
    }

    public void setOnboardStatus(Integer onboardStatus) {
        this.onboardStatus = onboardStatus;
    }

    public Integer getConversionStatus() {
        return this.conversionStatus;
    }

    public void setConversionStatus(Integer conversionStatus) {
        this.conversionStatus = conversionStatus;
    }

    public String getOnboardTime() {
        return this.onboardTime;
    }

    public void setOnboardTime(String onboardTime) {
        this.onboardTime = onboardTime;
    }

    public String getExpectedConversionTime() {
        return this.expectedConversionTime;
    }

    public void setExpectedConversionTime(String expectedConversionTime) {
        this.expectedConversionTime = expectedConversionTime;
    }

    public String getActualConversionTime() {
        return this.actualConversionTime;
    }

    public void setActualConversionTime(String actualConversionTime) {
        this.actualConversionTime = actualConversionTime;
    }

    public String getOverboardTime() {
        return this.overboardTime;
    }

    public void setOverboardTime(String overboardTime) {
        this.overboardTime = overboardTime;
    }

    public String getOverboardNote() {
        return this.overboardNote;
    }

    public void setOverboardNote(String overboardNote) {
        this.overboardNote = overboardNote;
    }

    public String getOnboardCityCode() {
        return this.onboardCityCode;
    }

    public void setOnboardCityCode(String onboardCityCode) {
        this.onboardCityCode = onboardCityCode;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public void setLeaderId(String leaderId) {
        this.leaderId = leaderId;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public String getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(String employeeType) {
        this.employeeType = employeeType;
    }

    public String getJobRequirementId() {
        return this.jobRequirementId;
    }

    public void setJobRequirementId(String jobRequirementId) {
        this.jobRequirementId = jobRequirementId;
    }

    public static class Builder {
        /**
         * 员工 ID
         * <p> 示例值：123
         */
        private String id;
        /**
         * 投递 ID
         * <p> 示例值：123
         */
        private String applicationId;
        /**
         * 入职状态
         * <p> 示例值：1
         */
        private Integer onboardStatus;
        /**
         * 转正状态
         * <p> 示例值：1
         */
        private Integer conversionStatus;
        /**
         * 实际入职时间
         * <p> 示例值：1637596800000
         */
        private String onboardTime;
        /**
         * 预期转正时间
         * <p> 示例值：1637596800000
         */
        private String expectedConversionTime;
        /**
         * 实际转正时间
         * <p> 示例值：1637596800000
         */
        private String actualConversionTime;
        /**
         * 离职时间
         * <p> 示例值：1637596800000
         */
        private String overboardTime;
        /**
         * 离职原因
         * <p> 示例值：职业发展考虑
         */
        private String overboardNote;
        /**
         * 办公地点
         * <p> 示例值：C20
         */
        private String onboardCityCode;
        /**
         * 入职部门 ID
         * <p> 示例值：6966123381141866028
         */
        private String departmentId;
        /**
         * 直属上级 ID
         * <p> 示例值：ou-xxx
         */
        private String leaderId;
        /**
         * 序列 ID
         * <p> 示例值：6501
         */
        private String sequenceId;
        /**
         * 职级 ID
         * <p> 示例值：6301
         */
        private String levelId;
        /**
         * 员工类型
         * <p> 示例值：1
         */
        private String employeeType;
        /**
         * 招聘需求ID
         * <p> 示例值：123123123213
         */
        private String jobRequirementId;

        /**
         * 员工 ID
         * <p> 示例值：123
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 投递 ID
         * <p> 示例值：123
         *
         * @param applicationId
         * @return
         */
        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }


        /**
         * 入职状态
         * <p> 示例值：1
         *
         * @param onboardStatus
         * @return
         */
        public Builder onboardStatus(Integer onboardStatus) {
            this.onboardStatus = onboardStatus;
            return this;
        }


        /**
         * 转正状态
         * <p> 示例值：1
         *
         * @param conversionStatus
         * @return
         */
        public Builder conversionStatus(Integer conversionStatus) {
            this.conversionStatus = conversionStatus;
            return this;
        }


        /**
         * 实际入职时间
         * <p> 示例值：1637596800000
         *
         * @param onboardTime
         * @return
         */
        public Builder onboardTime(String onboardTime) {
            this.onboardTime = onboardTime;
            return this;
        }


        /**
         * 预期转正时间
         * <p> 示例值：1637596800000
         *
         * @param expectedConversionTime
         * @return
         */
        public Builder expectedConversionTime(String expectedConversionTime) {
            this.expectedConversionTime = expectedConversionTime;
            return this;
        }


        /**
         * 实际转正时间
         * <p> 示例值：1637596800000
         *
         * @param actualConversionTime
         * @return
         */
        public Builder actualConversionTime(String actualConversionTime) {
            this.actualConversionTime = actualConversionTime;
            return this;
        }


        /**
         * 离职时间
         * <p> 示例值：1637596800000
         *
         * @param overboardTime
         * @return
         */
        public Builder overboardTime(String overboardTime) {
            this.overboardTime = overboardTime;
            return this;
        }


        /**
         * 离职原因
         * <p> 示例值：职业发展考虑
         *
         * @param overboardNote
         * @return
         */
        public Builder overboardNote(String overboardNote) {
            this.overboardNote = overboardNote;
            return this;
        }


        /**
         * 办公地点
         * <p> 示例值：C20
         *
         * @param onboardCityCode
         * @return
         */
        public Builder onboardCityCode(String onboardCityCode) {
            this.onboardCityCode = onboardCityCode;
            return this;
        }


        /**
         * 入职部门 ID
         * <p> 示例值：6966123381141866028
         *
         * @param departmentId
         * @return
         */
        public Builder departmentId(String departmentId) {
            this.departmentId = departmentId;
            return this;
        }


        /**
         * 直属上级 ID
         * <p> 示例值：ou-xxx
         *
         * @param leaderId
         * @return
         */
        public Builder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }


        /**
         * 序列 ID
         * <p> 示例值：6501
         *
         * @param sequenceId
         * @return
         */
        public Builder sequenceId(String sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }


        /**
         * 职级 ID
         * <p> 示例值：6301
         *
         * @param levelId
         * @return
         */
        public Builder levelId(String levelId) {
            this.levelId = levelId;
            return this;
        }


        /**
         * 员工类型
         * <p> 示例值：1
         *
         * @param employeeType
         * @return
         */
        public Builder employeeType(String employeeType) {
            this.employeeType = employeeType;
            return this;
        }


        /**
         * 招聘需求ID
         * <p> 示例值：123123123213
         *
         * @param jobRequirementId
         * @return
         */
        public Builder jobRequirementId(String jobRequirementId) {
            this.jobRequirementId = jobRequirementId;
            return this;
        }


        public EmployeeV2 build() {
            return new EmployeeV2(this);
        }
    }
}
