// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.helpdesk.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.helpdesk.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class TicketCustomizedField {
    /**
     * 工单自定义字段ID
     * <p> 示例值：6834320707288072194
     */
    @SerializedName("ticket_customized_field_id")
    private String ticketCustomizedFieldId;
    /**
     * 服务台ID
     * <p> 示例值：1542164574896126
     */
    @SerializedName("helpdesk_id")
    private String helpdeskId;
    /**
     * 键名
     * <p> 示例值：test dropdown
     */
    @SerializedName("key_name")
    private String keyName;
    /**
     * 名称
     * <p> 示例值：test dropdown
     */
    @SerializedName("display_name")
    private String displayName;
    /**
     * 字段在列表后台管理列表中的位置
     * <p> 示例值：3
     */
    @SerializedName("position")
    private String position;
    /**
     * 类型;;string - 单行文本;;multiline - 多行文本;;dropdown - 下拉列表;;dropdown_nested - 级联下拉
     * <p> 示例值：dropdown
     */
    @SerializedName("field_type")
    private String fieldType;
    /**
     * 描述
     * <p> 示例值：下拉示例
     */
    @SerializedName("description")
    private String description;
    /**
     * 是否可见
     * <p> 示例值：true
     */
    @SerializedName("visible")
    private Boolean visible;
    /**
     * 是否可以修改
     * <p> 示例值：true
     */
    @SerializedName("editable")
    private Boolean editable;
    /**
     * 是否必填
     * <p> 示例值：false
     */
    @SerializedName("required")
    private Boolean required;
    /**
     * 创建时间
     * <p> 示例值：1591239289000
     */
    @SerializedName("created_at")
    private String createdAt;
    /**
     * 更新时间
     * <p> 示例值：1591239289000
     */
    @SerializedName("updated_at")
    private String updatedAt;
    /**
     * 创建用户
     * <p> 示例值：
     */
    @SerializedName("created_by")
    private TicketUser createdBy;
    /**
     * 更新用户
     * <p> 示例值：
     */
    @SerializedName("updated_by")
    private TicketUser updatedBy;
    /**
     * 是否支持多选，仅在字段类型是dropdown的时候有效
     * <p> 示例值：true
     */
    @SerializedName("dropdown_allow_multiple")
    private Boolean dropdownAllowMultiple;

    // builder 开始
    public TicketCustomizedField() {
    }

    public TicketCustomizedField(Builder builder) {
        /**
         * 工单自定义字段ID
         * <p> 示例值：6834320707288072194
         */
        this.ticketCustomizedFieldId = builder.ticketCustomizedFieldId;
        /**
         * 服务台ID
         * <p> 示例值：1542164574896126
         */
        this.helpdeskId = builder.helpdeskId;
        /**
         * 键名
         * <p> 示例值：test dropdown
         */
        this.keyName = builder.keyName;
        /**
         * 名称
         * <p> 示例值：test dropdown
         */
        this.displayName = builder.displayName;
        /**
         * 字段在列表后台管理列表中的位置
         * <p> 示例值：3
         */
        this.position = builder.position;
        /**
         * 类型;;string - 单行文本;;multiline - 多行文本;;dropdown - 下拉列表;;dropdown_nested - 级联下拉
         * <p> 示例值：dropdown
         */
        this.fieldType = builder.fieldType;
        /**
         * 描述
         * <p> 示例值：下拉示例
         */
        this.description = builder.description;
        /**
         * 是否可见
         * <p> 示例值：true
         */
        this.visible = builder.visible;
        /**
         * 是否可以修改
         * <p> 示例值：true
         */
        this.editable = builder.editable;
        /**
         * 是否必填
         * <p> 示例值：false
         */
        this.required = builder.required;
        /**
         * 创建时间
         * <p> 示例值：1591239289000
         */
        this.createdAt = builder.createdAt;
        /**
         * 更新时间
         * <p> 示例值：1591239289000
         */
        this.updatedAt = builder.updatedAt;
        /**
         * 创建用户
         * <p> 示例值：
         */
        this.createdBy = builder.createdBy;
        /**
         * 更新用户
         * <p> 示例值：
         */
        this.updatedBy = builder.updatedBy;
        /**
         * 是否支持多选，仅在字段类型是dropdown的时候有效
         * <p> 示例值：true
         */
        this.dropdownAllowMultiple = builder.dropdownAllowMultiple;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTicketCustomizedFieldId() {
        return this.ticketCustomizedFieldId;
    }

    public void setTicketCustomizedFieldId(String ticketCustomizedFieldId) {
        this.ticketCustomizedFieldId = ticketCustomizedFieldId;
    }

    public String getHelpdeskId() {
        return this.helpdeskId;
    }

    public void setHelpdeskId(String helpdeskId) {
        this.helpdeskId = helpdeskId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TicketUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(TicketUser createdBy) {
        this.createdBy = createdBy;
    }

    public TicketUser getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(TicketUser updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Boolean getDropdownAllowMultiple() {
        return this.dropdownAllowMultiple;
    }

    public void setDropdownAllowMultiple(Boolean dropdownAllowMultiple) {
        this.dropdownAllowMultiple = dropdownAllowMultiple;
    }

    public static class Builder {
        /**
         * 工单自定义字段ID
         * <p> 示例值：6834320707288072194
         */
        private String ticketCustomizedFieldId;
        /**
         * 服务台ID
         * <p> 示例值：1542164574896126
         */
        private String helpdeskId;
        /**
         * 键名
         * <p> 示例值：test dropdown
         */
        private String keyName;
        /**
         * 名称
         * <p> 示例值：test dropdown
         */
        private String displayName;
        /**
         * 字段在列表后台管理列表中的位置
         * <p> 示例值：3
         */
        private String position;
        /**
         * 类型;;string - 单行文本;;multiline - 多行文本;;dropdown - 下拉列表;;dropdown_nested - 级联下拉
         * <p> 示例值：dropdown
         */
        private String fieldType;
        /**
         * 描述
         * <p> 示例值：下拉示例
         */
        private String description;
        /**
         * 是否可见
         * <p> 示例值：true
         */
        private Boolean visible;
        /**
         * 是否可以修改
         * <p> 示例值：true
         */
        private Boolean editable;
        /**
         * 是否必填
         * <p> 示例值：false
         */
        private Boolean required;
        /**
         * 创建时间
         * <p> 示例值：1591239289000
         */
        private String createdAt;
        /**
         * 更新时间
         * <p> 示例值：1591239289000
         */
        private String updatedAt;
        /**
         * 创建用户
         * <p> 示例值：
         */
        private TicketUser createdBy;
        /**
         * 更新用户
         * <p> 示例值：
         */
        private TicketUser updatedBy;
        /**
         * 是否支持多选，仅在字段类型是dropdown的时候有效
         * <p> 示例值：true
         */
        private Boolean dropdownAllowMultiple;

        /**
         * 工单自定义字段ID
         * <p> 示例值：6834320707288072194
         *
         * @param ticketCustomizedFieldId
         * @return
         */
        public Builder ticketCustomizedFieldId(String ticketCustomizedFieldId) {
            this.ticketCustomizedFieldId = ticketCustomizedFieldId;
            return this;
        }


        /**
         * 服务台ID
         * <p> 示例值：1542164574896126
         *
         * @param helpdeskId
         * @return
         */
        public Builder helpdeskId(String helpdeskId) {
            this.helpdeskId = helpdeskId;
            return this;
        }


        /**
         * 键名
         * <p> 示例值：test dropdown
         *
         * @param keyName
         * @return
         */
        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }


        /**
         * 名称
         * <p> 示例值：test dropdown
         *
         * @param displayName
         * @return
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }


        /**
         * 字段在列表后台管理列表中的位置
         * <p> 示例值：3
         *
         * @param position
         * @return
         */
        public Builder position(String position) {
            this.position = position;
            return this;
        }


        /**
         * 类型;;string - 单行文本;;multiline - 多行文本;;dropdown - 下拉列表;;dropdown_nested - 级联下拉
         * <p> 示例值：dropdown
         *
         * @param fieldType
         * @return
         */
        public Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }


        /**
         * 描述
         * <p> 示例值：下拉示例
         *
         * @param description
         * @return
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }


        /**
         * 是否可见
         * <p> 示例值：true
         *
         * @param visible
         * @return
         */
        public Builder visible(Boolean visible) {
            this.visible = visible;
            return this;
        }


        /**
         * 是否可以修改
         * <p> 示例值：true
         *
         * @param editable
         * @return
         */
        public Builder editable(Boolean editable) {
            this.editable = editable;
            return this;
        }


        /**
         * 是否必填
         * <p> 示例值：false
         *
         * @param required
         * @return
         */
        public Builder required(Boolean required) {
            this.required = required;
            return this;
        }


        /**
         * 创建时间
         * <p> 示例值：1591239289000
         *
         * @param createdAt
         * @return
         */
        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }


        /**
         * 更新时间
         * <p> 示例值：1591239289000
         *
         * @param updatedAt
         * @return
         */
        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * 创建用户
         * <p> 示例值：
         *
         * @param createdBy
         * @return
         */
        public Builder createdBy(TicketUser createdBy) {
            this.createdBy = createdBy;
            return this;
        }


        /**
         * 更新用户
         * <p> 示例值：
         *
         * @param updatedBy
         * @return
         */
        public Builder updatedBy(TicketUser updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }


        /**
         * 是否支持多选，仅在字段类型是dropdown的时候有效
         * <p> 示例值：true
         *
         * @param dropdownAllowMultiple
         * @return
         */
        public Builder dropdownAllowMultiple(Boolean dropdownAllowMultiple) {
            this.dropdownAllowMultiple = dropdownAllowMultiple;
            return this;
        }


        public TicketCustomizedField build() {
            return new TicketCustomizedField(this);
        }
    }
}
