// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.im.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class OpenAppFeedCard {
    /**
     * 业务 ID
     * <p> 示例值：096e2927-40a6-41a3-9562-314d641d09ae
     */
    @SerializedName("biz_id")
    private String bizId;
    /**
     * 主标题
     * <p> 示例值：主标题
     */
    @SerializedName("title")
    private String title;
    /**
     * 头像 key
     * <p> 示例值：v3_0041_007bca9f-67ba-4199-bf00-4031b12cf226
     */
    @SerializedName("avatar_key")
    private String avatarKey;
    /**
     * 预览信息
     * <p> 示例值：预览信息
     */
    @SerializedName("preview")
    private String preview;
    /**
     * 状态标签
     * <p> 示例值：
     */
    @SerializedName("status_label")
    private OpenFeedStatusLabel statusLabel;
    /**
     * 交互按钮
     * <p> 示例值：
     */
    @SerializedName("buttons")
    private OpenAppFeedCardButtons buttons;
    /**
     * 跳转链接
     * <p> 示例值：
     */
    @SerializedName("link")
    private OpenAppFeedLink link;
    /**
     * 即时提醒状态，true-打开，false-关闭
     * <p> 示例值：false
     */
    @SerializedName("time_sensitive")
    private Boolean timeSensitive;
    /**
     * 通知设置，当前可设置通知是否关闭，为空时默认进行通知
     * <p> 示例值：
     */
    @SerializedName("notify")
    private AppFeedNotify notify;

    // builder 开始
    public OpenAppFeedCard() {
    }

    public OpenAppFeedCard(Builder builder) {
        /**
         * 业务 ID
         * <p> 示例值：096e2927-40a6-41a3-9562-314d641d09ae
         */
        this.bizId = builder.bizId;
        /**
         * 主标题
         * <p> 示例值：主标题
         */
        this.title = builder.title;
        /**
         * 头像 key
         * <p> 示例值：v3_0041_007bca9f-67ba-4199-bf00-4031b12cf226
         */
        this.avatarKey = builder.avatarKey;
        /**
         * 预览信息
         * <p> 示例值：预览信息
         */
        this.preview = builder.preview;
        /**
         * 状态标签
         * <p> 示例值：
         */
        this.statusLabel = builder.statusLabel;
        /**
         * 交互按钮
         * <p> 示例值：
         */
        this.buttons = builder.buttons;
        /**
         * 跳转链接
         * <p> 示例值：
         */
        this.link = builder.link;
        /**
         * 即时提醒状态，true-打开，false-关闭
         * <p> 示例值：false
         */
        this.timeSensitive = builder.timeSensitive;
        /**
         * 通知设置，当前可设置通知是否关闭，为空时默认进行通知
         * <p> 示例值：
         */
        this.notify = builder.notify;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAvatarKey() {
        return this.avatarKey;
    }

    public void setAvatarKey(String avatarKey) {
        this.avatarKey = avatarKey;
    }

    public String getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    public OpenFeedStatusLabel getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(OpenFeedStatusLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    public OpenAppFeedCardButtons getButtons() {
        return this.buttons;
    }

    public void setButtons(OpenAppFeedCardButtons buttons) {
        this.buttons = buttons;
    }

    public OpenAppFeedLink getLink() {
        return this.link;
    }

    public void setLink(OpenAppFeedLink link) {
        this.link = link;
    }

    public Boolean getTimeSensitive() {
        return this.timeSensitive;
    }

    public void setTimeSensitive(Boolean timeSensitive) {
        this.timeSensitive = timeSensitive;
    }

    public AppFeedNotify getNotify() {
        return this.notify;
    }

    public void setNotify(AppFeedNotify notify) {
        this.notify = notify;
    }

    public static class Builder {
        /**
         * 业务 ID
         * <p> 示例值：096e2927-40a6-41a3-9562-314d641d09ae
         */
        private String bizId;
        /**
         * 主标题
         * <p> 示例值：主标题
         */
        private String title;
        /**
         * 头像 key
         * <p> 示例值：v3_0041_007bca9f-67ba-4199-bf00-4031b12cf226
         */
        private String avatarKey;
        /**
         * 预览信息
         * <p> 示例值：预览信息
         */
        private String preview;
        /**
         * 状态标签
         * <p> 示例值：
         */
        private OpenFeedStatusLabel statusLabel;
        /**
         * 交互按钮
         * <p> 示例值：
         */
        private OpenAppFeedCardButtons buttons;
        /**
         * 跳转链接
         * <p> 示例值：
         */
        private OpenAppFeedLink link;
        /**
         * 即时提醒状态，true-打开，false-关闭
         * <p> 示例值：false
         */
        private Boolean timeSensitive;
        /**
         * 通知设置，当前可设置通知是否关闭，为空时默认进行通知
         * <p> 示例值：
         */
        private AppFeedNotify notify;

        /**
         * 业务 ID
         * <p> 示例值：096e2927-40a6-41a3-9562-314d641d09ae
         *
         * @param bizId
         * @return
         */
        public Builder bizId(String bizId) {
            this.bizId = bizId;
            return this;
        }


        /**
         * 主标题
         * <p> 示例值：主标题
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 头像 key
         * <p> 示例值：v3_0041_007bca9f-67ba-4199-bf00-4031b12cf226
         *
         * @param avatarKey
         * @return
         */
        public Builder avatarKey(String avatarKey) {
            this.avatarKey = avatarKey;
            return this;
        }


        /**
         * 预览信息
         * <p> 示例值：预览信息
         *
         * @param preview
         * @return
         */
        public Builder preview(String preview) {
            this.preview = preview;
            return this;
        }


        /**
         * 状态标签
         * <p> 示例值：
         *
         * @param statusLabel
         * @return
         */
        public Builder statusLabel(OpenFeedStatusLabel statusLabel) {
            this.statusLabel = statusLabel;
            return this;
        }


        /**
         * 交互按钮
         * <p> 示例值：
         *
         * @param buttons
         * @return
         */
        public Builder buttons(OpenAppFeedCardButtons buttons) {
            this.buttons = buttons;
            return this;
        }


        /**
         * 跳转链接
         * <p> 示例值：
         *
         * @param link
         * @return
         */
        public Builder link(OpenAppFeedLink link) {
            this.link = link;
            return this;
        }


        /**
         * 即时提醒状态，true-打开，false-关闭
         * <p> 示例值：false
         *
         * @param timeSensitive
         * @return
         */
        public Builder timeSensitive(Boolean timeSensitive) {
            this.timeSensitive = timeSensitive;
            return this;
        }


        /**
         * 通知设置，当前可设置通知是否关闭，为空时默认进行通知
         * <p> 示例值：
         *
         * @param notify
         * @return
         */
        public Builder notify(AppFeedNotify notify) {
            this.notify = notify;
            return this;
        }


        public OpenAppFeedCard build() {
            return new OpenAppFeedCard(this);
        }
    }
}
