/*
 * Decompiled with CFR 0.152.
 */
package com.github.larseckart.tcr;

import com.github.larseckart.tcr.JPanelHelpers;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArlosGitNotationPrompt {
    private String message = "";
    private boolean done = false;
    private final JPanel panel = new JPanel();

    public ArlosGitNotationPrompt() {
        this.setLayout();
    }

    private void setLayout() {
        this.panel.setLayout(new GridBagLayout());
        this.addCustomCommitPart();
        this.addQuickKeys();
        this.addArlosGitNotation();
    }

    private void addArlosGitNotation() {
        int position = 4;
        JPanelHelpers.addHelpText(this.panel, "Arlo's Git Notation:", position++, true);
        this.addHelpText("------ High Risk ------", position++);
        this.addHelpText("F   Feature (< 9 LoC)", position++);
        this.addHelpText("B   Bug (< 9 LoC)", position++);
        this.addHelpText("R   Test-supported Refactoring", position++);
        this.addHelpText("F!! Feature (> 8 LoC)", position++);
        this.addHelpText("B!! Bug (> 8 LoC)", position++);
        this.addHelpText("R!! Non-provable refactoring", position++);
        this.addHelpText("*** Non-compiling commit", position++);
        position = 5;
        this.addHelpText2("------ Low  Risk ------", position++);
        this.addHelpText2("c   Comments (add/delete)", position++);
        this.addHelpText2("d   Developer documentation changes", position++);
        this.addHelpText2("e   Environment (non-code) changes", position++);
        this.addHelpText2("t   Test only change", position++);
        this.addHelpText2("r   Provable Refactoring", position++);
        this.addHelpText2("a   Automated formatting", position++);
    }

    private void addQuickKeys() {
        int position = 1;
        JPanelHelpers.addHelpText(this.panel, "Quick Actions:", 2, true);
        this.createQuickbutton("Rename", "r   Rename", 82, position++);
        this.createQuickbutton("Inline", "r   Inline", 73, position++);
        this.createQuickbutton("Extract Method", "r   Extract Method", 77, position++);
        this.createQuickbutton("Extract Variable", "r   Extract Variable", 86, position++);
        this.createQuickbutton("Delete Clutter", "r   Delete Clutter", 68, position++);
    }

    private void addCustomCommitPart() {
        GridBagConstraints c = new GridBagConstraints();
        JLabel commitLabel = new JLabel("Commit Message:");
        c.anchor = 23;
        c.insets = new Insets(10, 10, 0, 0);
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridy = 1;
        this.panel.add((Component)commitLabel, c);
        GridBagConstraints c2 = new GridBagConstraints();
        final JTextField prompt = new JTextField("");
        prompt.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArlosGitNotationPrompt.this.doCommit(prompt.getText());
            }
        });
        c2.fill = 2;
        c2.anchor = 18;
        c2.insets = new Insets(10, 10, 0, 0);
        c2.gridx = 2;
        c2.gridwidth = 3;
        c2.gridy = 1;
        this.panel.add((Component)prompt, c2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton commit = new JButton("Commit");
        commit.setMnemonic(67);
        commit.setDefaultCapable(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        commit.addActionListener(e -> this.doCommit(prompt.getText()));
        this.panel.add((Component)commit, gridBagConstraints);
    }

    private void addHelpText(String text, int position) {
        JPanelHelpers.addHelpText(this.panel, text, position, false);
    }

    private void addHelpText2(String text, int position) {
        this.addHelpText2(text, position, false);
    }

    private void addHelpText2(String text, int position, boolean first) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel helpText = new JLabel(text);
        Font font = new Font("Courier", first ? 1 : 0, 16);
        helpText.setFont(font);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(first ? 50 : 0, 10, 10, 0);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = position;
        this.panel.add((Component)helpText, gridBagConstraints);
    }

    private void createQuickbutton(String label, String commitMessage, int shortcut, int position) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton quick = new JButton(label);
        quick.setMnemonic(shortcut);
        quick.setDefaultCapable(true);
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridx = position;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 3;
        quick.addActionListener(e -> this.doCommit(commitMessage));
        this.panel.add((Component)quick, gridBagConstraints);
    }

    public void doCommit(String text) {
        this.message = text;
        this.done = true;
        Container parent = this.panel.getParent();
        while (!(parent instanceof JFrame)) {
            parent = parent.getParent();
        }
        ((JFrame)parent).dispose();
    }

    public static String display() {
        ArlosGitNotationPrompt panel = new ArlosGitNotationPrompt();
        ArlosGitNotationPrompt.openInFrame(panel);
        while (!panel.done) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return panel.message;
    }

    private static void openInFrame(ArlosGitNotationPrompt panel) {
        JFrame test = new JFrame("Commit...");
        test.getContentPane().add(panel.panel);
        test.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = test.getSize();
        int dx = (int)w.getWidth();
        int dy = (int)w.getHeight();
        int x = (int)((d.getWidth() - (double)dx) / 2.0);
        int y = (int)((d.getHeight() - (double)dy) / 2.0);
        test.setBounds(x, y, dx, dy + 1);
        test.setVisible(true);
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

