/*
 * Decompiled with CFR 0.152.
 */
package com.github.larseckart.tcr;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class SilentTestCommitRevertMainExtension
implements TestExecutionExceptionHandler,
AfterAllCallback {
    private static final boolean PRINT_ONLY = false;
    private boolean failures = false;

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.failures = true;
        throw throwable;
    }

    public void afterAll(ExtensionContext context) {
        File gitDir = SilentTestCommitRevertMainExtension.getRootFolder();
        if (gitDir == null) {
            System.err.println("No .git repo found at " + new File(".").getAbsolutePath());
            return;
        }
        if (this.failures) {
            SilentTestCommitRevertMainExtension.revertGit(gitDir);
        } else {
            SilentTestCommitRevertMainExtension.commit(gitDir);
        }
    }

    private static File getRootFolder() {
        try {
            File file = new File(".").getCanonicalFile();
            do {
                File gitFolder;
                if (!(gitFolder = new File(file, ".git")).exists()) continue;
                return file;
            } while ((file = file.getParentFile()) != null);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void revertGit(File gitDir) {
        SilentTestCommitRevertMainExtension.runOnConsole(gitDir, "git", "checkout", "src/main/");
        System.out.println("Test Failed, reverting...");
    }

    private static void commit(File gitDir) {
        if (SilentTestCommitRevertMainExtension.isGitEmpty(gitDir)) {
            System.out.println("Nothing to commit");
            return;
        }
        SilentTestCommitRevertMainExtension.runOnConsole(gitDir, "git", "add", "-A");
        SilentTestCommitRevertMainExtension.runOnConsole(gitDir, "git", "commit", "-m", "working");
    }

    private static boolean isGitEmpty(File gitDir) {
        try {
            SilentTestCommitRevertMainExtension.runOnConsole(gitDir, "git", "status");
            Process p = Runtime.getRuntime().exec(new String[]{"git", "status"}, null, gitDir);
            p.waitFor();
            String text = SilentTestCommitRevertMainExtension.readStream(p.getInputStream());
            return text.contains("nothing to commit");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String readStream(InputStream inputStream) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return string;
    }

    private static void runOnConsole(File workingDir, String ... cmdArgs) throws Error {
        try {
            Process p = Runtime.getRuntime().exec(cmdArgs, null, workingDir);
            p.waitFor();
            System.out.println(SilentTestCommitRevertMainExtension.readStream(p.getInputStream()));
            System.out.println(SilentTestCommitRevertMainExtension.readStream(p.getErrorStream()));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

