/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.apiserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.laserfiche.api.client.apiserver.TokenClient;
import com.laserfiche.api.client.model.ApiException;
import com.laserfiche.api.client.model.CreateConnectionRequest;
import com.laserfiche.api.client.model.ProblemDetails;
import com.laserfiche.api.client.model.SessionKeyInfo;
import com.laserfiche.api.client.tokenclients.BaseTokenClient;
import com.laserfiche.api.client.tokenclients.TokenClientUtils;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.json.JSONObject;

public class TokenClientImpl
extends BaseTokenClient
implements TokenClient {
    private final String baseUrl;

    public TokenClientImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public SessionKeyInfo createAccessToken(String repositoryId, CreateConnectionRequest body) {
        ProblemDetails problemDetails;
        Map<String, Object> pathParameters = this.getNonNullParameters(new String[]{"repoId"}, new Object[]{repositoryId});
        HttpResponse httpResponse = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)this.httpClient.post(this.baseUrl + "/v1/Repositories/{repoId}/Token").routeParam(pathParameters)).header("Accept", "application/json")).header("Content-Type", "application/x-www-form-urlencoded")).field("grant_type", (Object)"password").field("username", body.getUsername()).field("password", body.getPassword()).asObject(Object.class);
        if (httpResponse.getStatus() == 200) {
            try {
                String jsonString = new JSONObject(httpResponse.getBody()).toString();
                return (SessionKeyInfo)this.objectMapper.readValue(jsonString, SessionKeyInfo.class);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            String jsonString = new JSONObject(httpResponse.getBody()).toString();
            problemDetails = (ProblemDetails)this.objectMapper.readValue(jsonString, ProblemDetails.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        Map<String, String> headersMap = TokenClientUtils.getHeadersMap(httpResponse);
        if (httpResponse.getStatus() == 400) {
            throw new ApiException("Invalid or bad request.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 401) {
            throw new ApiException("Access token is invalid or expired.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 403) {
            throw new ApiException("Access denied for the operation.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 404) {
            throw new ApiException("Not found.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 429) {
            throw new ApiException("Rate limit is reached.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        throw new RuntimeException(httpResponse.getStatusText());
    }

    private Map<String, Object> getNonNullParameters(String[] parameterNames, Object[] parameters) {
        if (parameterNames == null || parameters == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        if (parameterNames.length != parameters.length) {
            throw new IllegalArgumentException("The array for parameter name and value should have the same length.");
        }
        HashMap<String, Object> paramKeyValuePairs = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null) continue;
            paramKeyValuePairs.put(parameterNames[i], parameters[i] instanceof String ? parameters[i] : String.valueOf(parameters[i]));
        }
        return paramKeyValuePairs;
    }
}

