/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.httphandlers;

import com.laserfiche.api.client.httphandlers.HeaderKeyValue;
import com.laserfiche.api.client.httphandlers.HeaderKeyValueImpl;
import com.laserfiche.api.client.httphandlers.Headers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HeadersImpl
implements Headers {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    @Override
    public void append(String name, String value) {
        if (value == null) {
            return;
        }
        this.headers.computeIfAbsent(name, key -> new ArrayList());
        this.headers.get(name).add(value);
    }

    @Override
    public void delete(String name) {
        if (!this.headers.containsKey(name)) {
            return;
        }
        this.headers.remove(name);
    }

    @Override
    public Collection<HeaderKeyValue> entries() {
        return this.headers.entrySet().stream().map(entry -> new HeaderKeyValueImpl((String)entry.getKey(), String.join((CharSequence)", ", (Iterable)entry.getValue()))).collect(Collectors.toList());
    }

    @Override
    public String get(String name) {
        if (!this.headers.containsKey(name)) {
            return null;
        }
        List<String> headerList = this.headers.get(name);
        return String.join((CharSequence)", ", headerList);
    }

    @Override
    public boolean has(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Set<String> keys() {
        return this.headers.keySet();
    }

    @Override
    public void set(String name, String value) {
        this.headers.computeIfAbsent(name, key -> new ArrayList());
        this.headers.get(name).add(value);
    }

    @Override
    public Collection<String> values() {
        return this.headers.values().stream().map(headerList -> String.join((CharSequence)", ", headerList)).collect(Collectors.toList());
    }
}

