/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.httphandlers;

import com.laserfiche.api.client.httphandlers.BeforeSendResult;
import com.laserfiche.api.client.httphandlers.HttpRequestHandler;
import com.laserfiche.api.client.httphandlers.Request;
import com.laserfiche.api.client.httphandlers.Response;
import com.laserfiche.api.client.model.AccessKey;
import com.laserfiche.api.client.model.GetAccessTokenResponse;
import com.laserfiche.api.client.oauth.TokenClient;
import com.laserfiche.api.client.oauth.TokenClientImpl;

public class OAuthClientCredentialsHandler
implements HttpRequestHandler {
    private String accessToken;
    private final String servicePrincipalKey;
    private final AccessKey accessKey;
    private final TokenClient client;

    public OAuthClientCredentialsHandler(String servicePrincipalKey, AccessKey accessKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        this.accessKey = accessKey;
        this.client = new TokenClientImpl(accessKey.getDomain());
    }

    @Override
    public BeforeSendResult beforeSend(Request request) {
        BeforeSendResult result = new BeforeSendResult();
        if (this.accessToken == null || this.accessToken.equals("")) {
            GetAccessTokenResponse tokenResponse = this.client.getAccessTokenFromServicePrincipal(this.servicePrincipalKey, this.accessKey);
            this.accessToken = tokenResponse.getAccessToken();
        }
        request.headers().append("Authorization", "Bearer " + this.accessToken);
        result.setRegionalDomain(this.accessKey.getDomain());
        return result;
    }

    @Override
    public boolean afterSend(Response response) {
        boolean shouldRetry;
        boolean bl = shouldRetry = response.status() == 401;
        if (shouldRetry) {
            this.accessToken = null;
        }
        return shouldRetry;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

