/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.httphandlers;

import com.laserfiche.api.client.apiserver.TokenClient;
import com.laserfiche.api.client.apiserver.TokenClientImpl;
import com.laserfiche.api.client.httphandlers.BeforeSendResult;
import com.laserfiche.api.client.httphandlers.HttpRequestHandler;
import com.laserfiche.api.client.httphandlers.Request;
import com.laserfiche.api.client.httphandlers.Response;
import com.laserfiche.api.client.model.CreateConnectionRequest;
import com.laserfiche.api.client.model.SessionKeyInfo;

public class UsernamePasswordHandler
implements HttpRequestHandler {
    private String accessToken;
    private final String grantType = "password";
    private final String repositoryId;
    private final String baseUrl;
    private final TokenClient client;
    private final CreateConnectionRequest request;

    public UsernamePasswordHandler(String repositoryId, String username, String password, String baseUrl, TokenClient client) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.repositoryId = repositoryId;
        this.request = new CreateConnectionRequest();
        this.request.setPassword(password);
        this.request.setUsername(username);
        this.request.setGrantType("password");
        this.client = client == null ? new TokenClientImpl(this.baseUrl) : client;
    }

    @Override
    public BeforeSendResult beforeSend(Request request) {
        BeforeSendResult result = new BeforeSendResult();
        if (this.accessToken == null) {
            SessionKeyInfo tokenResponse = this.client.createAccessToken(this.repositoryId, this.request);
            this.accessToken = tokenResponse.getAccessToken();
            request.headers().append("Authorization", "Bearer " + this.accessToken);
            return result;
        }
        request.headers().append("Authorization", "Bearer " + this.accessToken);
        return result;
    }

    @Override
    public boolean afterSend(Response response) {
        boolean shouldRetry;
        boolean bl = shouldRetry = response.status() == 401;
        if (shouldRetry) {
            this.accessToken = null;
        }
        return shouldRetry;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

