/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.model;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.laserfiche.api.client.deserialization.JwkDeserializer;
import com.laserfiche.api.client.tokenclients.TokenClientUtils;
import com.nimbusds.jose.jwk.JWK;
import java.io.IOException;

public class AccessKey {
    private String customerId;
    private String domain;
    private String clientId;
    private JWK jwk;
    private static ObjectMapper mapper;

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public JWK getJwk() {
        return this.jwk;
    }

    public void setJwk(JWK jwk) {
        this.jwk = jwk;
    }

    public static AccessKey createFromBase64EncodedAccessKey(String base64EncodedAccessKey) {
        if (mapper == null) {
            SimpleModule module = new SimpleModule();
            module.addDeserializer(JWK.class, (JsonDeserializer)new JwkDeserializer());
            mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).addModule((Module)module)).build();
        }
        if ((base64EncodedAccessKey = base64EncodedAccessKey.trim()).length() == 0) {
            throw new IllegalArgumentException("Input cannot be empty or null");
        }
        String accessKeyStr = TokenClientUtils.decodeBase64(base64EncodedAccessKey);
        AccessKey accessKey = null;
        try {
            accessKey = (AccessKey)mapper.readValue(accessKeyStr, AccessKey.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid access key. Detail: " + e, e);
        }
        return accessKey;
    }
}

