/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.laserfiche.api.client.model.AccessKey;
import com.laserfiche.api.client.model.ApiException;
import com.laserfiche.api.client.model.GetAccessTokenResponse;
import com.laserfiche.api.client.model.ProblemDetails;
import com.laserfiche.api.client.oauth.TokenClient;
import com.laserfiche.api.client.tokenclients.BaseTokenClient;
import com.laserfiche.api.client.tokenclients.TokenClientUtils;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.json.JSONObject;

public class TokenClientImpl
extends BaseTokenClient
implements TokenClient {
    private final String baseUrl;

    public TokenClientImpl(String regionalDomain) {
        this.baseUrl = TokenClientUtils.getOAuthApiBaseUri(regionalDomain);
    }

    @Override
    public GetAccessTokenResponse getAccessTokenFromServicePrincipal(String servicePrincipalKey, AccessKey accessKey) {
        ProblemDetails problemDetails;
        String bearer = TokenClientUtils.createBearer(servicePrincipalKey, accessKey);
        HttpResponse httpResponse = ((HttpRequestWithBody)((HttpRequestWithBody)this.httpClient.post(this.baseUrl + "Token").header("Authorization", bearer)).header("Content-Type", "application/x-www-form-urlencoded")).field("grant_type", (Object)"client_credentials").asObject(Object.class);
        if (httpResponse.getStatus() == 200) {
            try {
                String jsonString = new JSONObject(httpResponse.getBody()).toString();
                return (GetAccessTokenResponse)this.objectMapper.readValue(jsonString, GetAccessTokenResponse.class);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            String jsonString = new JSONObject(httpResponse.getBody()).toString();
            problemDetails = (ProblemDetails)this.objectMapper.readValue(jsonString, ProblemDetails.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        Map<String, String> headersMap = TokenClientUtils.getHeadersMap(httpResponse);
        if (httpResponse.getStatus() == 400) {
            throw new ApiException("Invalid or bad request.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 401) {
            throw new ApiException("Access token is invalid or expired.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 403) {
            throw new ApiException("Access denied for the operation.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 404) {
            throw new ApiException("Not found.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        if (httpResponse.getStatus() == 429) {
            throw new ApiException("Rate limit is reached.", httpResponse.getStatus(), httpResponse.getStatusText(), headersMap, problemDetails);
        }
        throw new RuntimeException(httpResponse.getStatusText());
    }
}

