/*
 * Decompiled with CFR 0.152.
 */
package com.laserfiche.api.client.tokenclients;

import com.laserfiche.api.client.model.AccessKey;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.ECKey;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kong.unirest.Header;
import kong.unirest.HttpResponse;

public class TokenClientUtils {
    private TokenClientUtils() {
        throw new IllegalStateException("Utility class with all static methods are not meant to be instantiated.");
    }

    public static String getOAuthApiBaseUri(String domain) {
        if (domain == null || domain.equals("")) {
            throw new IllegalArgumentException("domain");
        }
        return String.format("https://signin.%s/oauth/", domain);
    }

    public static String createBearer(String servicePrincipalKey, AccessKey accessKey) {
        ECKey jwk = accessKey.getJwk().toECKey();
        JWSObject jws = TokenClientUtils.createJws(jwk, servicePrincipalKey, accessKey);
        try {
            TokenClientUtils.sign(jws, jwk);
        }
        catch (JOSEException e) {
            return null;
        }
        return "Bearer " + jws.serialize();
    }

    public static String decodeBase64(String encoded) {
        byte[] decodedBytes = Base64.getUrlDecoder().decode(encoded);
        return new String(decodedBytes);
    }

    private static JWSObject createJws(ECKey jwk, String spKey, AccessKey accessKey) {
        long now = new Date().getTime() / 1000L;
        JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(jwk.getKeyID()).type(JOSEObjectType.JWT).build();
        String payloadTemplate = "{ \"client_id\": \"%s\", \"client_secret\": \"%s\", \"aud\": \"laserfiche.com\", \"exp\": %d, \"iat\": %d, \"nbf\": %d}";
        Payload jwsPayload = new Payload(String.format(payloadTemplate, accessKey.getClientId(), spKey, now + 1800L, now, now));
        return new JWSObject(jwsHeader, jwsPayload);
    }

    private static void sign(JWSObject jws, ECKey jwk) throws JOSEException {
        ECDSASigner signer = new ECDSASigner(jwk);
        jws.sign((JWSSigner)signer);
    }

    public static Map<String, String> getHeadersMap(HttpResponse httpResponse) {
        return httpResponse.getHeaders().all().stream().collect(Collectors.toMap(Header::getName, Header::getValue));
    }
}

