package com.laserfiche.repository.api;

import com.laserfiche.api.client.apiserver.TokenClient;
import com.laserfiche.api.client.httphandlers.BeforeSendResult;
import com.laserfiche.api.client.httphandlers.Request;
import com.laserfiche.api.client.httphandlers.RequestImpl;
import com.laserfiche.api.client.httphandlers.UsernamePasswordHandler;
import com.laserfiche.repository.api.clients.RepositoryApiClientInterceptor;
import kong.unirest.Config;
import kong.unirest.HttpRequest;

import java.util.concurrent.CompletableFuture;

public class SelfHostedInterceptor implements RepositoryApiClientInterceptor {
    private final UsernamePasswordHandler usernamePasswordHandler;

    public SelfHostedInterceptor(String repositoryId, String username, String password, String baseUrl,
            TokenClient client) {
        usernamePasswordHandler = new UsernamePasswordHandler(repositoryId, username, password, baseUrl, client);
    }

    @Override
    public void onRequest(HttpRequest<?> request, Config config) {
        Request customRequest = new RequestImpl();
        CompletableFuture<BeforeSendResult> future = usernamePasswordHandler.beforeSendAsync(customRequest);
        future.join(); // We are blocked by the HTTP handler
        request.header("Authorization", customRequest
                .headers()
                .get("Authorization"));
    }

    @Override
    public void close() {
        usernamePasswordHandler.close();
    }
}
