/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class EnvironmentBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="defaultTtl")
    private BigDecimal defaultTtl = null;

    public EnvironmentBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Development", required=true, value="The name of the new environment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnvironmentBody key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="dev", required=true, value="A project-unique key for the new environment")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public EnvironmentBody color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="417505", required=true, value="A color swatch (as an RGB hex value with no leading '#', e.g. C8C8C8)")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public EnvironmentBody defaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The default TTL for the new environment")
    public BigDecimal getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentBody environmentBody = (EnvironmentBody)o;
        return Objects.equals(this.name, environmentBody.name) && Objects.equals(this.key, environmentBody.key) && Objects.equals(this.color, environmentBody.color) && Objects.equals(this.defaultTtl, environmentBody.defaultTtl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.color, this.defaultTtl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvironmentBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

