/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.ExpiringUserTargetGetResponse;
import com.launchdarkly.api.model.ExpiringUserTargetPatchResponse;
import com.launchdarkly.api.model.PatchUsersRequest;
import com.launchdarkly.api.model.UserFlagSetting;
import com.launchdarkly.api.model.UserFlagSettings;
import com.launchdarkly.api.model.ValuePut;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class UserSettingsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UserSettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserSettingsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getExpiringFlagsForUserCall(String projectKey, String userKey, String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{userKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringFlagsForUserValidateBeforeCall(String projectKey, String userKey, String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringFlagsForUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getExpiringFlagsForUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringFlagsForUser(Async)");
        }
        Call localVarCall = this.getExpiringFlagsForUserCall(projectKey, userKey, environmentKey, _callback);
        return localVarCall;
    }

    public ExpiringUserTargetGetResponse getExpiringFlagsForUser(String projectKey, String userKey, String environmentKey) throws ApiException {
        ApiResponse<ExpiringUserTargetGetResponse> localVarResp = this.getExpiringFlagsForUserWithHttpInfo(projectKey, userKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetGetResponse> getExpiringFlagsForUserWithHttpInfo(String projectKey, String userKey, String environmentKey) throws ApiException {
        Call localVarCall = this.getExpiringFlagsForUserValidateBeforeCall(projectKey, userKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringFlagsForUserAsync(String projectKey, String userKey, String environmentKey, ApiCallback<ExpiringUserTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringFlagsForUserValidateBeforeCall(projectKey, userKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserFlagSettingCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}/{userKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserFlagSettingValidateBeforeCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserFlagSetting(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserFlagSetting(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getUserFlagSetting(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getUserFlagSetting(Async)");
        }
        Call localVarCall = this.getUserFlagSettingCall(projectKey, environmentKey, userKey, featureFlagKey, _callback);
        return localVarCall;
    }

    public UserFlagSetting getUserFlagSetting(String projectKey, String environmentKey, String userKey, String featureFlagKey) throws ApiException {
        ApiResponse<UserFlagSetting> localVarResp = this.getUserFlagSettingWithHttpInfo(projectKey, environmentKey, userKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<UserFlagSetting> getUserFlagSettingWithHttpInfo(String projectKey, String environmentKey, String userKey, String featureFlagKey) throws ApiException {
        Call localVarCall = this.getUserFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<UserFlagSetting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserFlagSettingAsync(String projectKey, String environmentKey, String userKey, String featureFlagKey, ApiCallback<UserFlagSetting> _callback) throws ApiException {
        Call localVarCall = this.getUserFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<UserFlagSetting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserFlagSettingsCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}/{userKey}/flags".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserFlagSettingsValidateBeforeCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserFlagSettings(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserFlagSettings(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getUserFlagSettings(Async)");
        }
        Call localVarCall = this.getUserFlagSettingsCall(projectKey, environmentKey, userKey, _callback);
        return localVarCall;
    }

    public UserFlagSettings getUserFlagSettings(String projectKey, String environmentKey, String userKey) throws ApiException {
        ApiResponse<UserFlagSettings> localVarResp = this.getUserFlagSettingsWithHttpInfo(projectKey, environmentKey, userKey);
        return localVarResp.getData();
    }

    public ApiResponse<UserFlagSettings> getUserFlagSettingsWithHttpInfo(String projectKey, String environmentKey, String userKey) throws ApiException {
        Call localVarCall = this.getUserFlagSettingsValidateBeforeCall(projectKey, environmentKey, userKey, null);
        Type localVarReturnType = new TypeToken<UserFlagSettings>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserFlagSettingsAsync(String projectKey, String environmentKey, String userKey, ApiCallback<UserFlagSettings> _callback) throws ApiException {
        Call localVarCall = this.getUserFlagSettingsValidateBeforeCall(projectKey, environmentKey, userKey, _callback);
        Type localVarReturnType = new TypeToken<UserFlagSettings>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringFlagsForUserCall(String projectKey, String userKey, String environmentKey, PatchUsersRequest patchUsersRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchUsersRequest localVarPostBody = patchUsersRequest;
        String localVarPath = "/api/v2/users/{projectKey}/{userKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringFlagsForUserValidateBeforeCall(String projectKey, String userKey, String environmentKey, PatchUsersRequest patchUsersRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringFlagsForUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling patchExpiringFlagsForUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringFlagsForUser(Async)");
        }
        if (patchUsersRequest == null) {
            throw new ApiException("Missing the required parameter 'patchUsersRequest' when calling patchExpiringFlagsForUser(Async)");
        }
        Call localVarCall = this.patchExpiringFlagsForUserCall(projectKey, userKey, environmentKey, patchUsersRequest, _callback);
        return localVarCall;
    }

    public ExpiringUserTargetPatchResponse patchExpiringFlagsForUser(String projectKey, String userKey, String environmentKey, PatchUsersRequest patchUsersRequest) throws ApiException {
        ApiResponse<ExpiringUserTargetPatchResponse> localVarResp = this.patchExpiringFlagsForUserWithHttpInfo(projectKey, userKey, environmentKey, patchUsersRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetPatchResponse> patchExpiringFlagsForUserWithHttpInfo(String projectKey, String userKey, String environmentKey, PatchUsersRequest patchUsersRequest) throws ApiException {
        Call localVarCall = this.patchExpiringFlagsForUserValidateBeforeCall(projectKey, userKey, environmentKey, patchUsersRequest, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringFlagsForUserAsync(String projectKey, String userKey, String environmentKey, PatchUsersRequest patchUsersRequest, ApiCallback<ExpiringUserTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringFlagsForUserValidateBeforeCall(projectKey, userKey, environmentKey, patchUsersRequest, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putFlagSettingCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, ValuePut valuePut, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ValuePut localVarPostBody = valuePut;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}/{userKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFlagSettingValidateBeforeCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, ValuePut valuePut, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putFlagSetting(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling putFlagSetting(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling putFlagSetting(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling putFlagSetting(Async)");
        }
        if (valuePut == null) {
            throw new ApiException("Missing the required parameter 'valuePut' when calling putFlagSetting(Async)");
        }
        Call localVarCall = this.putFlagSettingCall(projectKey, environmentKey, userKey, featureFlagKey, valuePut, _callback);
        return localVarCall;
    }

    public void putFlagSetting(String projectKey, String environmentKey, String userKey, String featureFlagKey, ValuePut valuePut) throws ApiException {
        this.putFlagSettingWithHttpInfo(projectKey, environmentKey, userKey, featureFlagKey, valuePut);
    }

    public ApiResponse<Void> putFlagSettingWithHttpInfo(String projectKey, String environmentKey, String userKey, String featureFlagKey, ValuePut valuePut) throws ApiException {
        Call localVarCall = this.putFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, valuePut, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putFlagSettingAsync(String projectKey, String environmentKey, String userKey, String featureFlagKey, ValuePut valuePut, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, valuePut, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

