/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.UserRecord;
import com.launchdarkly.api.model.Users;
import com.launchdarkly.api.model.UsersRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class UsersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteUserCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}/{userKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling deleteUser(Async)");
        }
        Call localVarCall = this.deleteUserCall(projectKey, environmentKey, userKey, _callback);
        return localVarCall;
    }

    public void deleteUser(String projectKey, String environmentKey, String userKey) throws ApiException {
        this.deleteUserWithHttpInfo(projectKey, environmentKey, userKey);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(String projectKey, String environmentKey, String userKey) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(projectKey, environmentKey, userKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(String projectKey, String environmentKey, String userKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(projectKey, environmentKey, userKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSearchUsersCall(String projectKey, String environmentKey, String q, Long limit, Long offset, Long after, String sort, String searchAfter, String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/user-search/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (searchAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("searchAfter", searchAfter));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSearchUsersValidateBeforeCall(String projectKey, String environmentKey, String q, Long limit, Long offset, Long after, String sort, String searchAfter, String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSearchUsers(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSearchUsers(Async)");
        }
        Call localVarCall = this.getSearchUsersCall(projectKey, environmentKey, q, limit, offset, after, sort, searchAfter, filter, _callback);
        return localVarCall;
    }

    public Users getSearchUsers(String projectKey, String environmentKey, String q, Long limit, Long offset, Long after, String sort, String searchAfter, String filter) throws ApiException {
        ApiResponse<Users> localVarResp = this.getSearchUsersWithHttpInfo(projectKey, environmentKey, q, limit, offset, after, sort, searchAfter, filter);
        return localVarResp.getData();
    }

    public ApiResponse<Users> getSearchUsersWithHttpInfo(String projectKey, String environmentKey, String q, Long limit, Long offset, Long after, String sort, String searchAfter, String filter) throws ApiException {
        Call localVarCall = this.getSearchUsersValidateBeforeCall(projectKey, environmentKey, q, limit, offset, after, sort, searchAfter, filter, null);
        Type localVarReturnType = new TypeToken<Users>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSearchUsersAsync(String projectKey, String environmentKey, String q, Long limit, Long offset, Long after, String sort, String searchAfter, String filter, ApiCallback<Users> _callback) throws ApiException {
        Call localVarCall = this.getSearchUsersValidateBeforeCall(projectKey, environmentKey, q, limit, offset, after, sort, searchAfter, filter, _callback);
        Type localVarReturnType = new TypeToken<Users>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}/{userKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(String projectKey, String environmentKey, String userKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getUser(Async)");
        }
        Call localVarCall = this.getUserCall(projectKey, environmentKey, userKey, _callback);
        return localVarCall;
    }

    public UserRecord getUser(String projectKey, String environmentKey, String userKey) throws ApiException {
        ApiResponse<UserRecord> localVarResp = this.getUserWithHttpInfo(projectKey, environmentKey, userKey);
        return localVarResp.getData();
    }

    public ApiResponse<UserRecord> getUserWithHttpInfo(String projectKey, String environmentKey, String userKey) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(projectKey, environmentKey, userKey, null);
        Type localVarReturnType = new TypeToken<UserRecord>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserAsync(String projectKey, String environmentKey, String userKey, ApiCallback<UserRecord> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(projectKey, environmentKey, userKey, _callback);
        Type localVarReturnType = new TypeToken<UserRecord>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUsersCall(String projectKey, String environmentKey, Long limit, String searchAfter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/users/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (searchAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("searchAfter", searchAfter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsersValidateBeforeCall(String projectKey, String environmentKey, Long limit, String searchAfter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUsers(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUsers(Async)");
        }
        Call localVarCall = this.getUsersCall(projectKey, environmentKey, limit, searchAfter, _callback);
        return localVarCall;
    }

    public UsersRep getUsers(String projectKey, String environmentKey, Long limit, String searchAfter) throws ApiException {
        ApiResponse<UsersRep> localVarResp = this.getUsersWithHttpInfo(projectKey, environmentKey, limit, searchAfter);
        return localVarResp.getData();
    }

    public ApiResponse<UsersRep> getUsersWithHttpInfo(String projectKey, String environmentKey, Long limit, String searchAfter) throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(projectKey, environmentKey, limit, searchAfter, null);
        Type localVarReturnType = new TypeToken<UsersRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUsersAsync(String projectKey, String environmentKey, Long limit, String searchAfter, ApiCallback<UsersRep> _callback) throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(projectKey, environmentKey, limit, searchAfter, _callback);
        Type localVarReturnType = new TypeToken<UsersRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

