/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.CreateWorkflowTemplateInput;
import com.launchdarkly.api.model.WorkflowTemplateOutput;
import com.launchdarkly.api.model.WorkflowTemplatesListingOutputRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WorkflowTemplatesBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowTemplatesBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTemplatesBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createWorkflowTemplateCall(CreateWorkflowTemplateInput createWorkflowTemplateInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateWorkflowTemplateInput localVarPostBody = createWorkflowTemplateInput;
        String localVarPath = "/api/v2/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWorkflowTemplateValidateBeforeCall(CreateWorkflowTemplateInput createWorkflowTemplateInput, ApiCallback _callback) throws ApiException {
        if (createWorkflowTemplateInput == null) {
            throw new ApiException("Missing the required parameter 'createWorkflowTemplateInput' when calling createWorkflowTemplate(Async)");
        }
        Call localVarCall = this.createWorkflowTemplateCall(createWorkflowTemplateInput, _callback);
        return localVarCall;
    }

    public WorkflowTemplateOutput createWorkflowTemplate(CreateWorkflowTemplateInput createWorkflowTemplateInput) throws ApiException {
        ApiResponse<WorkflowTemplateOutput> localVarResp = this.createWorkflowTemplateWithHttpInfo(createWorkflowTemplateInput);
        return localVarResp.getData();
    }

    public ApiResponse<WorkflowTemplateOutput> createWorkflowTemplateWithHttpInfo(CreateWorkflowTemplateInput createWorkflowTemplateInput) throws ApiException {
        Call localVarCall = this.createWorkflowTemplateValidateBeforeCall(createWorkflowTemplateInput, null);
        Type localVarReturnType = new TypeToken<WorkflowTemplateOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createWorkflowTemplateAsync(CreateWorkflowTemplateInput createWorkflowTemplateInput, ApiCallback<WorkflowTemplateOutput> _callback) throws ApiException {
        Call localVarCall = this.createWorkflowTemplateValidateBeforeCall(createWorkflowTemplateInput, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTemplateOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteWorkflowTemplateCall(String templateKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/templates/{templateKey}".replaceAll("\\{templateKey\\}", this.localVarApiClient.escapeString(templateKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkflowTemplateValidateBeforeCall(String templateKey, ApiCallback _callback) throws ApiException {
        if (templateKey == null) {
            throw new ApiException("Missing the required parameter 'templateKey' when calling deleteWorkflowTemplate(Async)");
        }
        Call localVarCall = this.deleteWorkflowTemplateCall(templateKey, _callback);
        return localVarCall;
    }

    public void deleteWorkflowTemplate(String templateKey) throws ApiException {
        this.deleteWorkflowTemplateWithHttpInfo(templateKey);
    }

    public ApiResponse<Void> deleteWorkflowTemplateWithHttpInfo(String templateKey) throws ApiException {
        Call localVarCall = this.deleteWorkflowTemplateValidateBeforeCall(templateKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWorkflowTemplateAsync(String templateKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkflowTemplateValidateBeforeCall(templateKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getWorkflowTemplatesCall(String search, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowTemplatesValidateBeforeCall(String search, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getWorkflowTemplatesCall(search, _callback);
        return localVarCall;
    }

    public WorkflowTemplatesListingOutputRep getWorkflowTemplates(String search) throws ApiException {
        ApiResponse<WorkflowTemplatesListingOutputRep> localVarResp = this.getWorkflowTemplatesWithHttpInfo(search);
        return localVarResp.getData();
    }

    public ApiResponse<WorkflowTemplatesListingOutputRep> getWorkflowTemplatesWithHttpInfo(String search) throws ApiException {
        Call localVarCall = this.getWorkflowTemplatesValidateBeforeCall(search, null);
        Type localVarReturnType = new TypeToken<WorkflowTemplatesListingOutputRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWorkflowTemplatesAsync(String search, ApiCallback<WorkflowTemplatesListingOutputRep> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowTemplatesValidateBeforeCall(search, _callback);
        Type localVarReturnType = new TypeToken<WorkflowTemplatesListingOutputRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

