/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.CustomWorkflowInput;
import com.launchdarkly.api.model.CustomWorkflowOutput;
import com.launchdarkly.api.model.CustomWorkflowsListingOutput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WorkflowsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteWorkflowCall(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows/{workflowId}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{workflowId\\}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkflowValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteWorkflow(Async)");
        }
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling deleteWorkflow(Async)");
        }
        Call localVarCall = this.deleteWorkflowCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        return localVarCall;
    }

    public void deleteWorkflow(String projectKey, String featureFlagKey, String environmentKey, String workflowId) throws ApiException {
        this.deleteWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, workflowId);
    }

    public ApiResponse<Void> deleteWorkflowWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String workflowId) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWorkflowAsync(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCustomWorkflowCall(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows/{workflowId}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{workflowId\\}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomWorkflowValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getCustomWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getCustomWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getCustomWorkflow(Async)");
        }
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling getCustomWorkflow(Async)");
        }
        Call localVarCall = this.getCustomWorkflowCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        return localVarCall;
    }

    public CustomWorkflowOutput getCustomWorkflow(String projectKey, String featureFlagKey, String environmentKey, String workflowId) throws ApiException {
        ApiResponse<CustomWorkflowOutput> localVarResp = this.getCustomWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, workflowId);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowOutput> getCustomWorkflowWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String workflowId) throws ApiException {
        Call localVarCall = this.getCustomWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCustomWorkflowAsync(String projectKey, String featureFlagKey, String environmentKey, String workflowId, ApiCallback<CustomWorkflowOutput> _callback) throws ApiException {
        Call localVarCall = this.getCustomWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWorkflowsCall(String projectKey, String featureFlagKey, String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getWorkflows(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getWorkflows(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getWorkflows(Async)");
        }
        Call localVarCall = this.getWorkflowsCall(projectKey, featureFlagKey, environmentKey, _callback);
        return localVarCall;
    }

    public CustomWorkflowsListingOutput getWorkflows(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<CustomWorkflowsListingOutput> localVarResp = this.getWorkflowsWithHttpInfo(projectKey, featureFlagKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowsListingOutput> getWorkflowsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowsListingOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWorkflowsAsync(String projectKey, String featureFlagKey, String environmentKey, ApiCallback<CustomWorkflowsListingOutput> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowsListingOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postWorkflowCall(String projectKey, String featureFlagKey, String environmentKey, CustomWorkflowInput customWorkflowInput, String templateKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomWorkflowInput localVarPostBody = customWorkflowInput;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templateKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templateKey", templateKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWorkflowValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, CustomWorkflowInput customWorkflowInput, String templateKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postWorkflow(Async)");
        }
        if (customWorkflowInput == null) {
            throw new ApiException("Missing the required parameter 'customWorkflowInput' when calling postWorkflow(Async)");
        }
        Call localVarCall = this.postWorkflowCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, _callback);
        return localVarCall;
    }

    public CustomWorkflowOutput postWorkflow(String projectKey, String featureFlagKey, String environmentKey, CustomWorkflowInput customWorkflowInput, String templateKey) throws ApiException {
        ApiResponse<CustomWorkflowOutput> localVarResp = this.postWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowOutput> postWorkflowWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, CustomWorkflowInput customWorkflowInput, String templateKey) throws ApiException {
        Call localVarCall = this.postWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postWorkflowAsync(String projectKey, String featureFlagKey, String environmentKey, CustomWorkflowInput customWorkflowInput, String templateKey, ApiCallback<CustomWorkflowOutput> _callback) throws ApiException {
        Call localVarCall = this.postWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

