/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AuthorizedAppDataRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberDataRep;
import com.launchdarkly.api.model.ParentResourceRep;
import com.launchdarkly.api.model.ResourceAccess;
import com.launchdarkly.api.model.SubjectDataRep;
import com.launchdarkly.api.model.TargetResourceRep;
import com.launchdarkly.api.model.TokenDataRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditLogEntryListingRep {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "_accountId";
    @SerializedName(value="_accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private Long date;
    public static final String SERIALIZED_NAME_ACCESSES = "accesses";
    @SerializedName(value="accesses")
    private List<ResourceAccess> accesses = new ArrayList<ResourceAccess>();
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_SHORT_DESCRIPTION = "shortDescription";
    @SerializedName(value="shortDescription")
    private String shortDescription;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private SubjectDataRep subject;
    public static final String SERIALIZED_NAME_MEMBER = "member";
    @SerializedName(value="member")
    private MemberDataRep member;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private TokenDataRep token;
    public static final String SERIALIZED_NAME_APP = "app";
    @SerializedName(value="app")
    private AuthorizedAppDataRep app;
    public static final String SERIALIZED_NAME_TITLE_VERB = "titleVerb";
    @SerializedName(value="titleVerb")
    private String titleVerb;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    private TargetResourceRep target;
    public static final String SERIALIZED_NAME_PARENT = "parent";
    @SerializedName(value="parent")
    private ParentResourceRep parent;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AuditLogEntryListingRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public AuditLogEntryListingRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public AuditLogEntryListingRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The ID of the audit log entry")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditLogEntryListingRep accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The ID of the account to which this audit log entry belongs")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AuditLogEntryListingRep date(Long date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public AuditLogEntryListingRep accesses(List<ResourceAccess> accesses) {
        this.accesses = accesses;
        return this;
    }

    public AuditLogEntryListingRep addAccessesItem(ResourceAccess accessesItem) {
        this.accesses.add(accessesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Details on the actions performed and resources acted on in this audit log entry")
    public List<ResourceAccess> getAccesses() {
        return this.accesses;
    }

    public void setAccesses(List<ResourceAccess> accesses) {
        this.accesses = accesses;
    }

    public AuditLogEntryListingRep kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public AuditLogEntryListingRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example feature flag", required=true, value="The name of the resource this audit log entry refers to")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuditLogEntryListingRep description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example, turning on the flag for testing", required=true, value="Description of the change recorded in the audit log entry")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AuditLogEntryListingRep shortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example, turning on the flag", required=true, value="Shorter version of the change recorded in the audit log entry")
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public AuditLogEntryListingRep comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is an automated test", value="Optional comment for the audit log entry")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public AuditLogEntryListingRep subject(SubjectDataRep subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubjectDataRep getSubject() {
        return this.subject;
    }

    public void setSubject(SubjectDataRep subject) {
        this.subject = subject;
    }

    public AuditLogEntryListingRep member(MemberDataRep member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberDataRep getMember() {
        return this.member;
    }

    public void setMember(MemberDataRep member) {
        this.member = member;
    }

    public AuditLogEntryListingRep token(TokenDataRep token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TokenDataRep getToken() {
        return this.token;
    }

    public void setToken(TokenDataRep token) {
        this.token = token;
    }

    public AuditLogEntryListingRep app(AuthorizedAppDataRep app) {
        this.app = app;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuthorizedAppDataRep getApp() {
        return this.app;
    }

    public void setApp(AuthorizedAppDataRep app) {
        this.app = app;
    }

    public AuditLogEntryListingRep titleVerb(String titleVerb) {
        this.titleVerb = titleVerb;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="turned on the flag", value="The action and resource recorded in this audit log entry")
    public String getTitleVerb() {
        return this.titleVerb;
    }

    public void setTitleVerb(String titleVerb) {
        this.titleVerb = titleVerb;
    }

    public AuditLogEntryListingRep title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A description of what occurred, in the format <code>member</code> <code>titleVerb</code> <code>target</code>")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AuditLogEntryListingRep target(TargetResourceRep target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TargetResourceRep getTarget() {
        return this.target;
    }

    public void setTarget(TargetResourceRep target) {
        this.target = target;
    }

    public AuditLogEntryListingRep parent(ParentResourceRep parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ParentResourceRep getParent() {
        return this.parent;
    }

    public void setParent(ParentResourceRep parent) {
        this.parent = parent;
    }

    public AuditLogEntryListingRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogEntryListingRep auditLogEntryListingRep = (AuditLogEntryListingRep)o;
        return Objects.equals(this.links, auditLogEntryListingRep.links) && Objects.equals(this.id, auditLogEntryListingRep.id) && Objects.equals(this.accountId, auditLogEntryListingRep.accountId) && Objects.equals(this.date, auditLogEntryListingRep.date) && Objects.equals(this.accesses, auditLogEntryListingRep.accesses) && Objects.equals(this.kind, auditLogEntryListingRep.kind) && Objects.equals(this.name, auditLogEntryListingRep.name) && Objects.equals(this.description, auditLogEntryListingRep.description) && Objects.equals(this.shortDescription, auditLogEntryListingRep.shortDescription) && Objects.equals(this.comment, auditLogEntryListingRep.comment) && Objects.equals(this.subject, auditLogEntryListingRep.subject) && Objects.equals(this.member, auditLogEntryListingRep.member) && Objects.equals(this.token, auditLogEntryListingRep.token) && Objects.equals(this.app, auditLogEntryListingRep.app) && Objects.equals(this.titleVerb, auditLogEntryListingRep.titleVerb) && Objects.equals(this.title, auditLogEntryListingRep.title) && Objects.equals(this.target, auditLogEntryListingRep.target) && Objects.equals(this.parent, auditLogEntryListingRep.parent) && Objects.equals(this.additionalProperties, auditLogEntryListingRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.accountId, this.date, this.accesses, this.kind, this.name, this.description, this.shortDescription, this.comment, this.subject, this.member, this.token, this.app, this.titleVerb, this.title, this.target, this.parent, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogEntryListingRep {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    accesses: ").append(this.toIndentedString(this.accesses)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    shortDescription: ").append(this.toIndentedString(this.shortDescription)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    titleVerb: ").append(this.toIndentedString(this.titleVerb)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AuditLogEntryListingRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_accountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        JsonArray jsonArrayaccesses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACCESSES);
        if (jsonArrayaccesses != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `accesses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESSES).toString()));
            }
            for (int i = 0; i < jsonArrayaccesses.size(); ++i) {
                ResourceAccess.validateJsonObject(jsonArrayaccesses.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shortDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBJECT) != null) {
            SubjectDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBJECT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER) != null) {
            MemberDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN) != null) {
            TokenDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APP) != null) {
            AuthorizedAppDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APP));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE_VERB) != null && !jsonObj.get(SERIALIZED_NAME_TITLE_VERB).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `titleVerb` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE_VERB).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET) != null) {
            TargetResourceRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PARENT) != null) {
            ParentResourceRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PARENT));
        }
    }

    public static AuditLogEntryListingRep fromJson(String jsonString) throws IOException {
        return (AuditLogEntryListingRep)JSON.getGson().fromJson(jsonString, AuditLogEntryListingRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_DATE);
        openapiFields.add(SERIALIZED_NAME_ACCESSES);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_SHORT_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_SUBJECT);
        openapiFields.add(SERIALIZED_NAME_MEMBER);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_APP);
        openapiFields.add(SERIALIZED_NAME_TITLE_VERB);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_TARGET);
        openapiFields.add(SERIALIZED_NAME_PARENT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCESSES);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_SHORT_DESCRIPTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AuditLogEntryListingRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AuditLogEntryListingRep.class));
            return new TypeAdapter<AuditLogEntryListingRep>(){

                public void write(JsonWriter out, AuditLogEntryListingRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AuditLogEntryListingRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AuditLogEntryListingRep.validateJsonObject(jsonObj);
                    AuditLogEntryListingRep instance = (AuditLogEntryListingRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

