/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AuditLogEntryListingRep;
import com.launchdarkly.api.model.AuthorizedAppDataRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberDataRep;
import com.launchdarkly.api.model.ParentResourceRep;
import com.launchdarkly.api.model.ResourceAccess;
import com.launchdarkly.api.model.SubjectDataRep;
import com.launchdarkly.api.model.TargetResourceRep;
import com.launchdarkly.api.model.TokenDataRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class AuditLogEntryRep {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "_accountId";
    @SerializedName(value="_accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private Long date;
    public static final String SERIALIZED_NAME_ACCESSES = "accesses";
    @SerializedName(value="accesses")
    private List<ResourceAccess> accesses = new ArrayList<ResourceAccess>();
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_SHORT_DESCRIPTION = "shortDescription";
    @SerializedName(value="shortDescription")
    private String shortDescription;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private SubjectDataRep subject;
    public static final String SERIALIZED_NAME_MEMBER = "member";
    @SerializedName(value="member")
    private MemberDataRep member;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private TokenDataRep token;
    public static final String SERIALIZED_NAME_APP = "app";
    @SerializedName(value="app")
    private AuthorizedAppDataRep app;
    public static final String SERIALIZED_NAME_TITLE_VERB = "titleVerb";
    @SerializedName(value="titleVerb")
    private String titleVerb;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    private TargetResourceRep target;
    public static final String SERIALIZED_NAME_PARENT = "parent";
    @SerializedName(value="parent")
    private ParentResourceRep parent;
    public static final String SERIALIZED_NAME_DELTA = "delta";
    @SerializedName(value="delta")
    private Object delta = null;
    public static final String SERIALIZED_NAME_TRIGGER_BODY = "triggerBody";
    @SerializedName(value="triggerBody")
    private Object triggerBody = null;
    public static final String SERIALIZED_NAME_MERGE = "merge";
    @SerializedName(value="merge")
    private Object merge = null;
    public static final String SERIALIZED_NAME_PREVIOUS_VERSION = "previousVersion";
    @SerializedName(value="previousVersion")
    private Object previousVersion = null;
    public static final String SERIALIZED_NAME_CURRENT_VERSION = "currentVersion";
    @SerializedName(value="currentVersion")
    private Object currentVersion = null;
    public static final String SERIALIZED_NAME_SUBENTRIES = "subentries";
    @SerializedName(value="subentries")
    private List<AuditLogEntryListingRep> subentries = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AuditLogEntryRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public AuditLogEntryRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public AuditLogEntryRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The ID of the audit log entry")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditLogEntryRep accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The ID of the account to which this audit log entry belongs")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AuditLogEntryRep date(Long date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public AuditLogEntryRep accesses(List<ResourceAccess> accesses) {
        this.accesses = accesses;
        return this;
    }

    public AuditLogEntryRep addAccessesItem(ResourceAccess accessesItem) {
        this.accesses.add(accessesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Details on the actions performed and resources acted on in this audit log entry")
    public List<ResourceAccess> getAccesses() {
        return this.accesses;
    }

    public void setAccesses(List<ResourceAccess> accesses) {
        this.accesses = accesses;
    }

    public AuditLogEntryRep kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public AuditLogEntryRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example feature flag", required=true, value="The name of the resource this audit log entry refers to")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuditLogEntryRep description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example, turning on the flag for testing", required=true, value="Description of the change recorded in the audit log entry")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AuditLogEntryRep shortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example, turning on the flag", required=true, value="Shorter version of the change recorded in the audit log entry")
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public AuditLogEntryRep comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is an automated test", value="Optional comment for the audit log entry")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public AuditLogEntryRep subject(SubjectDataRep subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubjectDataRep getSubject() {
        return this.subject;
    }

    public void setSubject(SubjectDataRep subject) {
        this.subject = subject;
    }

    public AuditLogEntryRep member(MemberDataRep member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberDataRep getMember() {
        return this.member;
    }

    public void setMember(MemberDataRep member) {
        this.member = member;
    }

    public AuditLogEntryRep token(TokenDataRep token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TokenDataRep getToken() {
        return this.token;
    }

    public void setToken(TokenDataRep token) {
        this.token = token;
    }

    public AuditLogEntryRep app(AuthorizedAppDataRep app) {
        this.app = app;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuthorizedAppDataRep getApp() {
        return this.app;
    }

    public void setApp(AuthorizedAppDataRep app) {
        this.app = app;
    }

    public AuditLogEntryRep titleVerb(String titleVerb) {
        this.titleVerb = titleVerb;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="turned on the flag", value="The action and resource recorded in this audit log entry")
    public String getTitleVerb() {
        return this.titleVerb;
    }

    public void setTitleVerb(String titleVerb) {
        this.titleVerb = titleVerb;
    }

    public AuditLogEntryRep title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A description of what occurred, in the format <code>member</code> <code>titleVerb</code> <code>target</code>")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AuditLogEntryRep target(TargetResourceRep target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TargetResourceRep getTarget() {
        return this.target;
    }

    public void setTarget(TargetResourceRep target) {
        this.target = target;
    }

    public AuditLogEntryRep parent(ParentResourceRep parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ParentResourceRep getParent() {
        return this.parent;
    }

    public void setParent(ParentResourceRep parent) {
        this.parent = parent;
    }

    public AuditLogEntryRep delta(Object delta) {
        this.delta = delta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the audit log entry has been updated, this is the JSON patch body that was used in the request to update the entity")
    public Object getDelta() {
        return this.delta;
    }

    public void setDelta(Object delta) {
        this.delta = delta;
    }

    public AuditLogEntryRep triggerBody(Object triggerBody) {
        this.triggerBody = triggerBody;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON representation of the external trigger for this audit log entry, if any")
    public Object getTriggerBody() {
        return this.triggerBody;
    }

    public void setTriggerBody(Object triggerBody) {
        this.triggerBody = triggerBody;
    }

    public AuditLogEntryRep merge(Object merge) {
        this.merge = merge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON representation of the merge information for this audit log entry, if any")
    public Object getMerge() {
        return this.merge;
    }

    public void setMerge(Object merge) {
        this.merge = merge;
    }

    public AuditLogEntryRep previousVersion(Object previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the audit log entry has been updated, this is a JSON representation of the previous version of the entity")
    public Object getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(Object previousVersion) {
        this.previousVersion = previousVersion;
    }

    public AuditLogEntryRep currentVersion(Object currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the audit log entry has been updated, this is a JSON representation of the current version of the entity")
    public Object getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Object currentVersion) {
        this.currentVersion = currentVersion;
    }

    public AuditLogEntryRep subentries(List<AuditLogEntryListingRep> subentries) {
        this.subentries = subentries;
        return this;
    }

    public AuditLogEntryRep addSubentriesItem(AuditLogEntryListingRep subentriesItem) {
        if (this.subentries == null) {
            this.subentries = new ArrayList<AuditLogEntryListingRep>();
        }
        this.subentries.add(subentriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<AuditLogEntryListingRep> getSubentries() {
        return this.subentries;
    }

    public void setSubentries(List<AuditLogEntryListingRep> subentries) {
        this.subentries = subentries;
    }

    public AuditLogEntryRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogEntryRep auditLogEntryRep = (AuditLogEntryRep)o;
        return Objects.equals(this.links, auditLogEntryRep.links) && Objects.equals(this.id, auditLogEntryRep.id) && Objects.equals(this.accountId, auditLogEntryRep.accountId) && Objects.equals(this.date, auditLogEntryRep.date) && Objects.equals(this.accesses, auditLogEntryRep.accesses) && Objects.equals(this.kind, auditLogEntryRep.kind) && Objects.equals(this.name, auditLogEntryRep.name) && Objects.equals(this.description, auditLogEntryRep.description) && Objects.equals(this.shortDescription, auditLogEntryRep.shortDescription) && Objects.equals(this.comment, auditLogEntryRep.comment) && Objects.equals(this.subject, auditLogEntryRep.subject) && Objects.equals(this.member, auditLogEntryRep.member) && Objects.equals(this.token, auditLogEntryRep.token) && Objects.equals(this.app, auditLogEntryRep.app) && Objects.equals(this.titleVerb, auditLogEntryRep.titleVerb) && Objects.equals(this.title, auditLogEntryRep.title) && Objects.equals(this.target, auditLogEntryRep.target) && Objects.equals(this.parent, auditLogEntryRep.parent) && Objects.equals(this.delta, auditLogEntryRep.delta) && Objects.equals(this.triggerBody, auditLogEntryRep.triggerBody) && Objects.equals(this.merge, auditLogEntryRep.merge) && Objects.equals(this.previousVersion, auditLogEntryRep.previousVersion) && Objects.equals(this.currentVersion, auditLogEntryRep.currentVersion) && Objects.equals(this.subentries, auditLogEntryRep.subentries) && Objects.equals(this.additionalProperties, auditLogEntryRep.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.accountId, this.date, this.accesses, this.kind, this.name, this.description, this.shortDescription, this.comment, this.subject, this.member, this.token, this.app, this.titleVerb, this.title, this.target, this.parent, this.delta, this.triggerBody, this.merge, this.previousVersion, this.currentVersion, this.subentries, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogEntryRep {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    accesses: ").append(this.toIndentedString(this.accesses)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    shortDescription: ").append(this.toIndentedString(this.shortDescription)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    titleVerb: ").append(this.toIndentedString(this.titleVerb)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    delta: ").append(this.toIndentedString(this.delta)).append("\n");
        sb.append("    triggerBody: ").append(this.toIndentedString(this.triggerBody)).append("\n");
        sb.append("    merge: ").append(this.toIndentedString(this.merge)).append("\n");
        sb.append("    previousVersion: ").append(this.toIndentedString(this.previousVersion)).append("\n");
        sb.append("    currentVersion: ").append(this.toIndentedString(this.currentVersion)).append("\n");
        sb.append("    subentries: ").append(this.toIndentedString(this.subentries)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysubentries;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AuditLogEntryRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_accountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        JsonArray jsonArrayaccesses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACCESSES);
        if (jsonArrayaccesses != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `accesses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESSES).toString()));
            }
            for (int i = 0; i < jsonArrayaccesses.size(); ++i) {
                ResourceAccess.validateJsonObject(jsonArrayaccesses.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shortDescription` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHORT_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBJECT) != null) {
            SubjectDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBJECT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER) != null) {
            MemberDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN) != null) {
            TokenDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APP) != null) {
            AuthorizedAppDataRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APP));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE_VERB) != null && !jsonObj.get(SERIALIZED_NAME_TITLE_VERB).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `titleVerb` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE_VERB).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET) != null) {
            TargetResourceRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PARENT) != null) {
            ParentResourceRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PARENT));
        }
        if ((jsonArraysubentries = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBENTRIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBENTRIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subentries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBENTRIES).toString()));
            }
            for (int i = 0; i < jsonArraysubentries.size(); ++i) {
                AuditLogEntryListingRep.validateJsonObject(jsonArraysubentries.get(i).getAsJsonObject());
            }
        }
    }

    public static AuditLogEntryRep fromJson(String jsonString) throws IOException {
        return (AuditLogEntryRep)JSON.getGson().fromJson(jsonString, AuditLogEntryRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_DATE);
        openapiFields.add(SERIALIZED_NAME_ACCESSES);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_SHORT_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_SUBJECT);
        openapiFields.add(SERIALIZED_NAME_MEMBER);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_APP);
        openapiFields.add(SERIALIZED_NAME_TITLE_VERB);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_TARGET);
        openapiFields.add(SERIALIZED_NAME_PARENT);
        openapiFields.add(SERIALIZED_NAME_DELTA);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_BODY);
        openapiFields.add(SERIALIZED_NAME_MERGE);
        openapiFields.add(SERIALIZED_NAME_PREVIOUS_VERSION);
        openapiFields.add(SERIALIZED_NAME_CURRENT_VERSION);
        openapiFields.add(SERIALIZED_NAME_SUBENTRIES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCESSES);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_SHORT_DESCRIPTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AuditLogEntryRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AuditLogEntryRep.class));
            return new TypeAdapter<AuditLogEntryRep>(){

                public void write(JsonWriter out, AuditLogEntryRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AuditLogEntryRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AuditLogEntryRep.validateJsonObject(jsonObj);
                    AuditLogEntryRep instance = (AuditLogEntryRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

