/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BigSegmentTarget {
    public static final String SERIALIZED_NAME_USER_KEY = "userKey";
    @SerializedName(value="userKey")
    private String userKey;
    public static final String SERIALIZED_NAME_INCLUDED = "included";
    @SerializedName(value="included")
    private Boolean included;
    public static final String SERIALIZED_NAME_EXCLUDED = "excluded";
    @SerializedName(value="excluded")
    private Boolean excluded;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BigSegmentTarget userKey(String userKey) {
        this.userKey = userKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The user key")
    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public BigSegmentTarget included(Boolean included) {
        this.included = included;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates whether the user is included.<br />Included users are always segment members, regardless of segment rules.")
    public Boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(Boolean included) {
        this.included = included;
    }

    public BigSegmentTarget excluded(Boolean excluded) {
        this.excluded = excluded;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates whether the user is excluded.<br />Segment rules bypass excluded users, so they will never be included based on rules. Excluded users may still be included explicitly.")
    public Boolean getExcluded() {
        return this.excluded;
    }

    public void setExcluded(Boolean excluded) {
        this.excluded = excluded;
    }

    public BigSegmentTarget putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigSegmentTarget bigSegmentTarget = (BigSegmentTarget)o;
        return Objects.equals(this.userKey, bigSegmentTarget.userKey) && Objects.equals(this.included, bigSegmentTarget.included) && Objects.equals(this.excluded, bigSegmentTarget.excluded) && Objects.equals(this.additionalProperties, bigSegmentTarget.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.userKey, this.included, this.excluded, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BigSegmentTarget {\n");
        sb.append("    userKey: ").append(this.toIndentedString(this.userKey)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    excluded: ").append(this.toIndentedString(this.excluded)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BigSegmentTarget is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_KEY) != null && !jsonObj.get(SERIALIZED_NAME_USER_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `userKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_KEY).toString()));
        }
    }

    public static BigSegmentTarget fromJson(String jsonString) throws IOException {
        return (BigSegmentTarget)JSON.getGson().fromJson(jsonString, BigSegmentTarget.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_USER_KEY);
        openapiFields.add(SERIALIZED_NAME_INCLUDED);
        openapiFields.add(SERIALIZED_NAME_EXCLUDED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_USER_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_INCLUDED);
        openapiRequiredFields.add(SERIALIZED_NAME_EXCLUDED);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!BigSegmentTarget.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BigSegmentTarget.class));
            return new TypeAdapter<BigSegmentTarget>(){

                public void write(JsonWriter out, BigSegmentTarget value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public BigSegmentTarget read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BigSegmentTarget.validateJsonObject(jsonObj);
                    BigSegmentTarget instance = (BigSegmentTarget)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

