/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.IterationRep;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Experiment {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "_maintainerId";
    @SerializedName(value="_maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_ARCHIVED_DATE = "archivedDate";
    @SerializedName(value="archivedDate")
    private Long archivedDate;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_CURRENT_ITERATION = "currentIteration";
    @SerializedName(value="currentIteration")
    private IterationRep currentIteration;
    public static final String SERIALIZED_NAME_DRAFT_ITERATION = "draftIteration";
    @SerializedName(value="draftIteration")
    private IterationRep draftIteration;
    public static final String SERIALIZED_NAME_PREVIOUS_ITERATIONS = "previousIterations";
    @SerializedName(value="previousIterations")
    private List<IterationRep> previousIterations = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Experiment id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910fgh12345", value="The experiment ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Experiment key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-experiment", required=true, value="The experiment key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Experiment name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example experiment", required=true, value="The experiment name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Experiment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="An example experiment, used in testing", value="The experiment description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experiment maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12ab3c45de678910fgh12345", required=true, value="The ID of the member who maintains this experiment.")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public Experiment creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Experiment archivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
    }

    public Experiment links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Experiment putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/projects/my-project/environments/my-environment\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/projects/my-project/environments/my-environment/experiments/my-experiment\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Experiment currentIteration(IterationRep currentIteration) {
        this.currentIteration = currentIteration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IterationRep getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(IterationRep currentIteration) {
        this.currentIteration = currentIteration;
    }

    public Experiment draftIteration(IterationRep draftIteration) {
        this.draftIteration = draftIteration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IterationRep getDraftIteration() {
        return this.draftIteration;
    }

    public void setDraftIteration(IterationRep draftIteration) {
        this.draftIteration = draftIteration;
    }

    public Experiment previousIterations(List<IterationRep> previousIterations) {
        this.previousIterations = previousIterations;
        return this;
    }

    public Experiment addPreviousIterationsItem(IterationRep previousIterationsItem) {
        if (this.previousIterations == null) {
            this.previousIterations = new ArrayList<IterationRep>();
        }
        this.previousIterations.add(previousIterationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the previous iterations for this experiment.")
    public List<IterationRep> getPreviousIterations() {
        return this.previousIterations;
    }

    public void setPreviousIterations(List<IterationRep> previousIterations) {
        this.previousIterations = previousIterations;
    }

    public Experiment putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Experiment experiment = (Experiment)o;
        return Objects.equals(this.id, experiment.id) && Objects.equals(this.key, experiment.key) && Objects.equals(this.name, experiment.name) && Objects.equals(this.description, experiment.description) && Objects.equals(this.maintainerId, experiment.maintainerId) && Objects.equals(this.creationDate, experiment.creationDate) && Objects.equals(this.archivedDate, experiment.archivedDate) && Objects.equals(this.links, experiment.links) && Objects.equals(this.currentIteration, experiment.currentIteration) && Objects.equals(this.draftIteration, experiment.draftIteration) && Objects.equals(this.previousIterations, experiment.previousIterations) && Objects.equals(this.additionalProperties, experiment.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.name, this.description, this.maintainerId, this.creationDate, this.archivedDate, this.links, this.currentIteration, this.draftIteration, this.previousIterations, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Experiment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    currentIteration: ").append(this.toIndentedString(this.currentIteration)).append("\n");
        sb.append("    draftIteration: ").append(this.toIndentedString(this.draftIteration)).append("\n");
        sb.append("    previousIterations: ").append(this.toIndentedString(this.previousIterations)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypreviousIterations;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Experiment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT_ITERATION) != null) {
            IterationRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT_ITERATION));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DRAFT_ITERATION) != null) {
            IterationRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DRAFT_ITERATION));
        }
        if ((jsonArraypreviousIterations = jsonObj.getAsJsonArray(SERIALIZED_NAME_PREVIOUS_ITERATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PREVIOUS_ITERATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `previousIterations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREVIOUS_ITERATIONS).toString()));
            }
            for (int i = 0; i < jsonArraypreviousIterations.size(); ++i) {
                IterationRep.validateJsonObject(jsonArraypreviousIterations.get(i).getAsJsonObject());
            }
        }
    }

    public static Experiment fromJson(String jsonString) throws IOException {
        return (Experiment)JSON.getGson().fromJson(jsonString, Experiment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_ARCHIVED_DATE);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_ITERATION);
        openapiFields.add(SERIALIZED_NAME_DRAFT_ITERATION);
        openapiFields.add(SERIALIZED_NAME_PREVIOUS_ITERATIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Experiment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Experiment.class));
            return new TypeAdapter<Experiment>(){

                public void write(JsonWriter out, Experiment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Experiment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Experiment.validateJsonObject(jsonObj);
                    Experiment instance = (Experiment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

