/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.FlagSummary;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.Prerequisite;
import com.launchdarkly.api.model.Rule;
import com.launchdarkly.api.model.Target;
import com.launchdarkly.api.model.VariationOrRolloutRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FeatureFlagConfig {
    public static final String SERIALIZED_NAME_ON = "on";
    @SerializedName(value="on")
    private Boolean on;
    public static final String SERIALIZED_NAME_ARCHIVED = "archived";
    @SerializedName(value="archived")
    private Boolean archived;
    public static final String SERIALIZED_NAME_SALT = "salt";
    @SerializedName(value="salt")
    private String salt;
    public static final String SERIALIZED_NAME_SEL = "sel";
    @SerializedName(value="sel")
    private String sel;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "lastModified";
    @SerializedName(value="lastModified")
    private Long lastModified;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_TARGETS = "targets";
    @SerializedName(value="targets")
    private List<Target> targets = null;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<Rule> rules = null;
    public static final String SERIALIZED_NAME_FALLTHROUGH = "fallthrough";
    @SerializedName(value="fallthrough")
    private VariationOrRolloutRep fallthrough;
    public static final String SERIALIZED_NAME_OFF_VARIATION = "offVariation";
    @SerializedName(value="offVariation")
    private Integer offVariation;
    public static final String SERIALIZED_NAME_PREREQUISITES = "prerequisites";
    @SerializedName(value="prerequisites")
    private List<Prerequisite> prerequisites = null;
    public static final String SERIALIZED_NAME_SITE = "_site";
    @SerializedName(value="_site")
    private Link site;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_ENVIRONMENT_NAME = "_environmentName";
    @SerializedName(value="_environmentName")
    private String environmentName;
    public static final String SERIALIZED_NAME_TRACK_EVENTS = "trackEvents";
    @SerializedName(value="trackEvents")
    private Boolean trackEvents;
    public static final String SERIALIZED_NAME_TRACK_EVENTS_FALLTHROUGH = "trackEventsFallthrough";
    @SerializedName(value="trackEventsFallthrough")
    private Boolean trackEventsFallthrough;
    public static final String SERIALIZED_NAME_DEBUG_EVENTS_UNTIL_DATE = "_debugEventsUntilDate";
    @SerializedName(value="_debugEventsUntilDate")
    private Long debugEventsUntilDate;
    public static final String SERIALIZED_NAME_SUMMARY = "_summary";
    @SerializedName(value="_summary")
    private FlagSummary summary;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FeatureFlagConfig on(Boolean on) {
        this.on = on;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public FeatureFlagConfig archived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public FeatureFlagConfig salt(String salt) {
        this.salt = salt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public FeatureFlagConfig sel(String sel) {
        this.sel = sel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getSel() {
        return this.sel;
    }

    public void setSel(String sel) {
        this.sel = sel;
    }

    public FeatureFlagConfig lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public FeatureFlagConfig version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FeatureFlagConfig targets(List<Target> targets) {
        this.targets = targets;
        return this;
    }

    public FeatureFlagConfig addTargetsItem(Target targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<Target>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public FeatureFlagConfig rules(List<Rule> rules) {
        this.rules = rules;
        return this;
    }

    public FeatureFlagConfig addRulesItem(Rule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public FeatureFlagConfig fallthrough(VariationOrRolloutRep fallthrough) {
        this.fallthrough = fallthrough;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VariationOrRolloutRep getFallthrough() {
        return this.fallthrough;
    }

    public void setFallthrough(VariationOrRolloutRep fallthrough) {
        this.fallthrough = fallthrough;
    }

    public FeatureFlagConfig offVariation(Integer offVariation) {
        this.offVariation = offVariation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getOffVariation() {
        return this.offVariation;
    }

    public void setOffVariation(Integer offVariation) {
        this.offVariation = offVariation;
    }

    public FeatureFlagConfig prerequisites(List<Prerequisite> prerequisites) {
        this.prerequisites = prerequisites;
        return this;
    }

    public FeatureFlagConfig addPrerequisitesItem(Prerequisite prerequisitesItem) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<Prerequisite>();
        }
        this.prerequisites.add(prerequisitesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<Prerequisite> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public FeatureFlagConfig site(Link site) {
        this.site = site;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Link getSite() {
        return this.site;
    }

    public void setSite(Link site) {
        this.site = site;
    }

    public FeatureFlagConfig access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public FeatureFlagConfig environmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public FeatureFlagConfig trackEvents(Boolean trackEvents) {
        this.trackEvents = trackEvents;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getTrackEvents() {
        return this.trackEvents;
    }

    public void setTrackEvents(Boolean trackEvents) {
        this.trackEvents = trackEvents;
    }

    public FeatureFlagConfig trackEventsFallthrough(Boolean trackEventsFallthrough) {
        this.trackEventsFallthrough = trackEventsFallthrough;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getTrackEventsFallthrough() {
        return this.trackEventsFallthrough;
    }

    public void setTrackEventsFallthrough(Boolean trackEventsFallthrough) {
        this.trackEventsFallthrough = trackEventsFallthrough;
    }

    public FeatureFlagConfig debugEventsUntilDate(Long debugEventsUntilDate) {
        this.debugEventsUntilDate = debugEventsUntilDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getDebugEventsUntilDate() {
        return this.debugEventsUntilDate;
    }

    public void setDebugEventsUntilDate(Long debugEventsUntilDate) {
        this.debugEventsUntilDate = debugEventsUntilDate;
    }

    public FeatureFlagConfig summary(FlagSummary summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FlagSummary getSummary() {
        return this.summary;
    }

    public void setSummary(FlagSummary summary) {
        this.summary = summary;
    }

    public FeatureFlagConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlagConfig featureFlagConfig = (FeatureFlagConfig)o;
        return Objects.equals(this.on, featureFlagConfig.on) && Objects.equals(this.archived, featureFlagConfig.archived) && Objects.equals(this.salt, featureFlagConfig.salt) && Objects.equals(this.sel, featureFlagConfig.sel) && Objects.equals(this.lastModified, featureFlagConfig.lastModified) && Objects.equals(this.version, featureFlagConfig.version) && Objects.equals(this.targets, featureFlagConfig.targets) && Objects.equals(this.rules, featureFlagConfig.rules) && Objects.equals(this.fallthrough, featureFlagConfig.fallthrough) && Objects.equals(this.offVariation, featureFlagConfig.offVariation) && Objects.equals(this.prerequisites, featureFlagConfig.prerequisites) && Objects.equals(this.site, featureFlagConfig.site) && Objects.equals(this.access, featureFlagConfig.access) && Objects.equals(this.environmentName, featureFlagConfig.environmentName) && Objects.equals(this.trackEvents, featureFlagConfig.trackEvents) && Objects.equals(this.trackEventsFallthrough, featureFlagConfig.trackEventsFallthrough) && Objects.equals(this.debugEventsUntilDate, featureFlagConfig.debugEventsUntilDate) && Objects.equals(this.summary, featureFlagConfig.summary) && Objects.equals(this.additionalProperties, featureFlagConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.on, this.archived, this.salt, this.sel, this.lastModified, this.version, this.targets, this.rules, this.fallthrough, this.offVariation, this.prerequisites, this.site, this.access, this.environmentName, this.trackEvents, this.trackEventsFallthrough, this.debugEventsUntilDate, this.summary, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlagConfig {\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    salt: ").append(this.toIndentedString(this.salt)).append("\n");
        sb.append("    sel: ").append(this.toIndentedString(this.sel)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    targets: ").append(this.toIndentedString(this.targets)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    fallthrough: ").append(this.toIndentedString(this.fallthrough)).append("\n");
        sb.append("    offVariation: ").append(this.toIndentedString(this.offVariation)).append("\n");
        sb.append("    prerequisites: ").append(this.toIndentedString(this.prerequisites)).append("\n");
        sb.append("    site: ").append(this.toIndentedString(this.site)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    environmentName: ").append(this.toIndentedString(this.environmentName)).append("\n");
        sb.append("    trackEvents: ").append(this.toIndentedString(this.trackEvents)).append("\n");
        sb.append("    trackEventsFallthrough: ").append(this.toIndentedString(this.trackEventsFallthrough)).append("\n");
        sb.append("    debugEventsUntilDate: ").append(this.toIndentedString(this.debugEventsUntilDate)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayprerequisites;
        JsonArray jsonArrayrules;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FeatureFlagConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SALT) != null && !jsonObj.get(SERIALIZED_NAME_SALT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `salt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SALT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEL) != null && !jsonObj.get(SERIALIZED_NAME_SEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEL).toString()));
        }
        JsonArray jsonArraytargets = jsonObj.getAsJsonArray(SERIALIZED_NAME_TARGETS);
        if (jsonArraytargets != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TARGETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `targets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGETS).toString()));
            }
            for (int i = 0; i < jsonArraytargets.size(); ++i) {
                Target.validateJsonObject(jsonArraytargets.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayrules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `rules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULES).toString()));
            }
            for (int i = 0; i < jsonArrayrules.size(); ++i) {
                Rule.validateJsonObject(jsonArrayrules.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FALLTHROUGH) != null) {
            VariationOrRolloutRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FALLTHROUGH));
        }
        if ((jsonArrayprerequisites = jsonObj.getAsJsonArray(SERIALIZED_NAME_PREREQUISITES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PREREQUISITES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `prerequisites` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREREQUISITES).toString()));
            }
            for (int i = 0; i < jsonArrayprerequisites.size(); ++i) {
                Prerequisite.validateJsonObject(jsonArrayprerequisites.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SITE) != null) {
            Link.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SITE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_environmentName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SUMMARY) != null) {
            FlagSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUMMARY));
        }
    }

    public static FeatureFlagConfig fromJson(String jsonString) throws IOException {
        return (FeatureFlagConfig)JSON.getGson().fromJson(jsonString, FeatureFlagConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ON);
        openapiFields.add(SERIALIZED_NAME_ARCHIVED);
        openapiFields.add(SERIALIZED_NAME_SALT);
        openapiFields.add(SERIALIZED_NAME_SEL);
        openapiFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_TARGETS);
        openapiFields.add(SERIALIZED_NAME_RULES);
        openapiFields.add(SERIALIZED_NAME_FALLTHROUGH);
        openapiFields.add(SERIALIZED_NAME_OFF_VARIATION);
        openapiFields.add(SERIALIZED_NAME_PREREQUISITES);
        openapiFields.add(SERIALIZED_NAME_SITE);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_NAME);
        openapiFields.add(SERIALIZED_NAME_TRACK_EVENTS);
        openapiFields.add(SERIALIZED_NAME_TRACK_EVENTS_FALLTHROUGH);
        openapiFields.add(SERIALIZED_NAME_DEBUG_EVENTS_UNTIL_DATE);
        openapiFields.add(SERIALIZED_NAME_SUMMARY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ON);
        openapiRequiredFields.add(SERIALIZED_NAME_ARCHIVED);
        openapiRequiredFields.add(SERIALIZED_NAME_SALT);
        openapiRequiredFields.add(SERIALIZED_NAME_SEL);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_SITE);
        openapiRequiredFields.add(SERIALIZED_NAME_ENVIRONMENT_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TRACK_EVENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_TRACK_EVENTS_FALLTHROUGH);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FeatureFlagConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FeatureFlagConfig.class));
            return new TypeAdapter<FeatureFlagConfig>(){

                public void write(JsonWriter out, FeatureFlagConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FeatureFlagConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FeatureFlagConfig.validateJsonObject(jsonObj);
                    FeatureFlagConfig instance = (FeatureFlagConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

