/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ClientSideAvailability;
import com.launchdarkly.api.model.CustomProperty;
import com.launchdarkly.api.model.Defaults;
import com.launchdarkly.api.model.ExperimentInfoRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberSummary;
import com.launchdarkly.api.model.Variation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlagGlobalAttributesRep {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_INCLUDE_IN_SNIPPET = "includeInSnippet";
    @SerializedName(value="includeInSnippet")
    private Boolean includeInSnippet;
    public static final String SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY = "clientSideAvailability";
    @SerializedName(value="clientSideAvailability")
    private ClientSideAvailability clientSideAvailability;
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    private List<Variation> variations = new ArrayList<Variation>();
    public static final String SERIALIZED_NAME_TEMPORARY = "temporary";
    @SerializedName(value="temporary")
    private Boolean temporary;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "maintainerId";
    @SerializedName(value="maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_MAINTAINER = "_maintainer";
    @SerializedName(value="_maintainer")
    private MemberSummary maintainer;
    public static final String SERIALIZED_NAME_GOAL_IDS = "goalIds";
    @SerializedName(value="goalIds")
    private List<String> goalIds = null;
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    private ExperimentInfoRep experiments;
    public static final String SERIALIZED_NAME_CUSTOM_PROPERTIES = "customProperties";
    @SerializedName(value="customProperties")
    private Map<String, CustomProperty> customProperties = new HashMap<String, CustomProperty>();
    public static final String SERIALIZED_NAME_ARCHIVED = "archived";
    @SerializedName(value="archived")
    private Boolean archived;
    public static final String SERIALIZED_NAME_ARCHIVED_DATE = "archivedDate";
    @SerializedName(value="archivedDate")
    private Long archivedDate;
    public static final String SERIALIZED_NAME_DEFAULTS = "defaults";
    @SerializedName(value="defaults")
    private Defaults defaults;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagGlobalAttributesRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Flag", required=true, value="A human-friendly name for the feature flag")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlagGlobalAttributesRep kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="boolean", required=true, value="Kind of feature flag")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public FlagGlobalAttributesRep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This flag controls the example widgets", value="Description of the feature flag")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FlagGlobalAttributesRep key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-flag", required=true, value="A unique key used to reference the flag in your code")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FlagGlobalAttributesRep version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Version of the feature flag")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FlagGlobalAttributesRep creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public FlagGlobalAttributesRep includeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Deprecated, use <code>clientSideAvailability</code>. Whether this flag should be made available to the client-side JavaScript SDK")
    public Boolean getIncludeInSnippet() {
        return this.includeInSnippet;
    }

    public void setIncludeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
    }

    public FlagGlobalAttributesRep clientSideAvailability(ClientSideAvailability clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ClientSideAvailability getClientSideAvailability() {
        return this.clientSideAvailability;
    }

    public void setClientSideAvailability(ClientSideAvailability clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
    }

    public FlagGlobalAttributesRep variations(List<Variation> variations) {
        this.variations = variations;
        return this;
    }

    public FlagGlobalAttributesRep addVariationsItem(Variation variationsItem) {
        this.variations.add(variationsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[{\"_id\":\"e432f62b-55f6-49dd-a02f-eb24acf39d05\",\"value\":true},{\"_id\":\"a00bf58d-d252-476c-b915-15a74becacb4\",\"value\":false}]", required=true, value="An array of possible variations for the flag")
    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    public FlagGlobalAttributesRep temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether the flag is a temporary flag")
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FlagGlobalAttributesRep tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FlagGlobalAttributesRep addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"example-tag\"]", required=true, value="Tags for the feature flag")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FlagGlobalAttributesRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public FlagGlobalAttributesRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/flags/my-project\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/flags/my-project/my-flag\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public FlagGlobalAttributesRep maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="569f183514f4432160000007", value="Associated maintainerId for the feature flag")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public FlagGlobalAttributesRep maintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberSummary getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
    }

    public FlagGlobalAttributesRep goalIds(List<String> goalIds) {
        this.goalIds = goalIds;
        return this;
    }

    public FlagGlobalAttributesRep addGoalIdsItem(String goalIdsItem) {
        if (this.goalIds == null) {
            this.goalIds = new ArrayList<String>();
        }
        this.goalIds.add(goalIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="Deprecated")
    public List<String> getGoalIds() {
        return this.goalIds;
    }

    public void setGoalIds(List<String> goalIds) {
        this.goalIds = goalIds;
    }

    public FlagGlobalAttributesRep experiments(ExperimentInfoRep experiments) {
        this.experiments = experiments;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ExperimentInfoRep getExperiments() {
        return this.experiments;
    }

    public void setExperiments(ExperimentInfoRep experiments) {
        this.experiments = experiments;
    }

    public FlagGlobalAttributesRep customProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public FlagGlobalAttributesRep putCustomPropertiesItem(String key, CustomProperty customPropertiesItem) {
        this.customProperties.put(key, customPropertiesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Map<String, CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public FlagGlobalAttributesRep archived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Boolean indicating if the feature flag is archived")
    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public FlagGlobalAttributesRep archivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
    }

    public FlagGlobalAttributesRep defaults(Defaults defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Defaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    public FlagGlobalAttributesRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagGlobalAttributesRep flagGlobalAttributesRep = (FlagGlobalAttributesRep)o;
        return Objects.equals(this.name, flagGlobalAttributesRep.name) && Objects.equals((Object)this.kind, (Object)flagGlobalAttributesRep.kind) && Objects.equals(this.description, flagGlobalAttributesRep.description) && Objects.equals(this.key, flagGlobalAttributesRep.key) && Objects.equals(this.version, flagGlobalAttributesRep.version) && Objects.equals(this.creationDate, flagGlobalAttributesRep.creationDate) && Objects.equals(this.includeInSnippet, flagGlobalAttributesRep.includeInSnippet) && Objects.equals(this.clientSideAvailability, flagGlobalAttributesRep.clientSideAvailability) && Objects.equals(this.variations, flagGlobalAttributesRep.variations) && Objects.equals(this.temporary, flagGlobalAttributesRep.temporary) && Objects.equals(this.tags, flagGlobalAttributesRep.tags) && Objects.equals(this.links, flagGlobalAttributesRep.links) && Objects.equals(this.maintainerId, flagGlobalAttributesRep.maintainerId) && Objects.equals(this.maintainer, flagGlobalAttributesRep.maintainer) && Objects.equals(this.goalIds, flagGlobalAttributesRep.goalIds) && Objects.equals(this.experiments, flagGlobalAttributesRep.experiments) && Objects.equals(this.customProperties, flagGlobalAttributesRep.customProperties) && Objects.equals(this.archived, flagGlobalAttributesRep.archived) && Objects.equals(this.archivedDate, flagGlobalAttributesRep.archivedDate) && Objects.equals(this.defaults, flagGlobalAttributesRep.defaults) && Objects.equals(this.additionalProperties, flagGlobalAttributesRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.description, this.key, this.version, this.creationDate, this.includeInSnippet, this.clientSideAvailability, this.variations, this.temporary, this.tags, this.links, this.maintainerId, this.maintainer, this.goalIds, this.experiments, this.customProperties, this.archived, this.archivedDate, this.defaults, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagGlobalAttributesRep {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    includeInSnippet: ").append(this.toIndentedString(this.includeInSnippet)).append("\n");
        sb.append("    clientSideAvailability: ").append(this.toIndentedString(this.clientSideAvailability)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    goalIds: ").append(this.toIndentedString(this.goalIds)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvariations;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagGlobalAttributesRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY) != null) {
            ClientSideAvailability.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY));
        }
        if ((jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayvariations.size(); ++i) {
                Variation.validateJsonObject(jsonArrayvariations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER) != null) {
            MemberSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER));
        }
        if (jsonObj.get(SERIALIZED_NAME_GOAL_IDS) != null && !jsonObj.get(SERIALIZED_NAME_GOAL_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `goalIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GOAL_IDS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENTS) != null) {
            ExperimentInfoRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENTS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULTS) != null) {
            Defaults.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULTS));
        }
    }

    public static FlagGlobalAttributesRep fromJson(String jsonString) throws IOException {
        return (FlagGlobalAttributesRep)JSON.getGson().fromJson(jsonString, FlagGlobalAttributesRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_IN_SNIPPET);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_VARIATIONS);
        openapiFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER);
        openapiFields.add(SERIALIZED_NAME_GOAL_IDS);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENTS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_PROPERTIES);
        openapiFields.add(SERIALIZED_NAME_ARCHIVED);
        openapiFields.add(SERIALIZED_NAME_ARCHIVED_DATE);
        openapiFields.add(SERIALIZED_NAME_DEFAULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_VARIATIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPERIMENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_CUSTOM_PROPERTIES);
        openapiRequiredFields.add(SERIALIZED_NAME_ARCHIVED);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagGlobalAttributesRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagGlobalAttributesRep.class));
            return new TypeAdapter<FlagGlobalAttributesRep>(){

                public void write(JsonWriter out, FlagGlobalAttributesRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagGlobalAttributesRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagGlobalAttributesRep.validateJsonObject(jsonObj);
                    FlagGlobalAttributesRep instance = (FlagGlobalAttributesRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        BOOLEAN("boolean"),
        MULTIVARIATE("multivariate");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

