/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberSummary;
import com.launchdarkly.api.model.Modification;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricListingRep {
    public static final String SERIALIZED_NAME_EXPERIMENT_COUNT = "experimentCount";
    @SerializedName(value="experimentCount")
    private Integer experimentCount;
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_ATTACHED_FLAG_COUNT = "_attachedFlagCount";
    @SerializedName(value="_attachedFlagCount")
    private Integer attachedFlagCount;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_SITE = "_site";
    @SerializedName(value="_site")
    private Link site;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "lastModified";
    @SerializedName(value="lastModified")
    private Modification lastModified;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "maintainerId";
    @SerializedName(value="maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_MAINTAINER = "_maintainer";
    @SerializedName(value="_maintainer")
    private MemberSummary maintainer;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_IS_NUMERIC = "isNumeric";
    @SerializedName(value="isNumeric")
    private Boolean isNumeric;
    public static final String SERIALIZED_NAME_SUCCESS_CRITERIA = "successCriteria";
    @SerializedName(value="successCriteria")
    private SuccessCriteriaEnum successCriteria;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_EVENT_KEY = "eventKey";
    @SerializedName(value="eventKey")
    private String eventKey;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MetricListingRep experimentCount(Integer experimentCount) {
        this.experimentCount = experimentCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The number of experiments using this metric")
    public Integer getExperimentCount() {
        return this.experimentCount;
    }

    public void setExperimentCount(Integer experimentCount) {
        this.experimentCount = experimentCount;
    }

    public MetricListingRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="5902deadbeef667524a01290", required=true, value="The ID of this metric")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricListingRep key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-metric", required=true, value="A unique key to reference the metric")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MetricListingRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-metric", required=true, value="A human-friendly name for the metric")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricListingRep kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="custom", required=true, value="The kind of event the metric tracks")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public MetricListingRep attachedFlagCount(Integer attachedFlagCount) {
        this.attachedFlagCount = attachedFlagCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The number of feature flags currently attached to this metric")
    public Integer getAttachedFlagCount() {
        return this.attachedFlagCount;
    }

    public void setAttachedFlagCount(Integer attachedFlagCount) {
        this.attachedFlagCount = attachedFlagCount;
    }

    public MetricListingRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MetricListingRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/metrics/my-project\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/metrics/my-project/my-metric\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public MetricListingRep site(Link site) {
        this.site = site;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Link getSite() {
        return this.site;
    }

    public void setSite(Link site) {
        this.site = site;
    }

    public MetricListingRep access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public MetricListingRep tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricListingRep addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[]", required=true, value="Tags for the metric")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MetricListingRep creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public MetricListingRep lastModified(Modification lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Modification getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Modification lastModified) {
        this.lastModified = lastModified;
    }

    public MetricListingRep maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="569fdeadbeef1644facecafe", value="The ID of the member who maintains this metric")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public MetricListingRep maintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberSummary getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
    }

    public MetricListingRep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the metric")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MetricListingRep isNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="For custom metrics, whether to track numeric changes in value against a baseline (<code>true</code>) or to track a conversion when users taken an action (<code>false</code>).")
    public Boolean getIsNumeric() {
        return this.isNumeric;
    }

    public void setIsNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public MetricListingRep successCriteria(SuccessCriteriaEnum successCriteria) {
        this.successCriteria = successCriteria;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For numeric custom metrics, the success criteria")
    public SuccessCriteriaEnum getSuccessCriteria() {
        return this.successCriteria;
    }

    public void setSuccessCriteria(SuccessCriteriaEnum successCriteria) {
        this.successCriteria = successCriteria;
    }

    public MetricListingRep unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For numeric custom metrics, the unit of measure")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetricListingRep eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For custom metrics, the event name to use in your code")
    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public MetricListingRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricListingRep metricListingRep = (MetricListingRep)o;
        return Objects.equals(this.experimentCount, metricListingRep.experimentCount) && Objects.equals(this.id, metricListingRep.id) && Objects.equals(this.key, metricListingRep.key) && Objects.equals(this.name, metricListingRep.name) && Objects.equals((Object)this.kind, (Object)metricListingRep.kind) && Objects.equals(this.attachedFlagCount, metricListingRep.attachedFlagCount) && Objects.equals(this.links, metricListingRep.links) && Objects.equals(this.site, metricListingRep.site) && Objects.equals(this.access, metricListingRep.access) && Objects.equals(this.tags, metricListingRep.tags) && Objects.equals(this.creationDate, metricListingRep.creationDate) && Objects.equals(this.lastModified, metricListingRep.lastModified) && Objects.equals(this.maintainerId, metricListingRep.maintainerId) && Objects.equals(this.maintainer, metricListingRep.maintainer) && Objects.equals(this.description, metricListingRep.description) && Objects.equals(this.isNumeric, metricListingRep.isNumeric) && Objects.equals((Object)this.successCriteria, (Object)metricListingRep.successCriteria) && Objects.equals(this.unit, metricListingRep.unit) && Objects.equals(this.eventKey, metricListingRep.eventKey) && Objects.equals(this.additionalProperties, metricListingRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.experimentCount, this.id, this.key, this.name, this.kind, this.attachedFlagCount, this.links, this.site, this.access, this.tags, this.creationDate, this.lastModified, this.maintainerId, this.maintainer, this.description, this.isNumeric, this.successCriteria, this.unit, this.eventKey, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricListingRep {\n");
        sb.append("    experimentCount: ").append(this.toIndentedString(this.experimentCount)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    attachedFlagCount: ").append(this.toIndentedString(this.attachedFlagCount)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    site: ").append(this.toIndentedString(this.site)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isNumeric: ").append(this.toIndentedString(this.isNumeric)).append("\n");
        sb.append("    successCriteria: ").append(this.toIndentedString((Object)this.successCriteria)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    eventKey: ").append(this.toIndentedString(this.eventKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MetricListingRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SITE) != null) {
            Link.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SITE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_MODIFIED) != null) {
            Modification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_MODIFIED));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER) != null) {
            MemberSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA) != null && !jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `successCriteria` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eventKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_KEY).toString()));
        }
    }

    public static MetricListingRep fromJson(String jsonString) throws IOException {
        return (MetricListingRep)JSON.getGson().fromJson(jsonString, MetricListingRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXPERIMENT_COUNT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_ATTACHED_FLAG_COUNT);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_SITE);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_IS_NUMERIC);
        openapiFields.add(SERIALIZED_NAME_SUCCESS_CRITERIA);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_EVENT_KEY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricListingRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricListingRep.class));
            return new TypeAdapter<MetricListingRep>(){

                public void write(JsonWriter out, MetricListingRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricListingRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MetricListingRep.validateJsonObject(jsonObj);
                    MetricListingRep instance = (MetricListingRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SuccessCriteriaEnum {
        HIGHERTHANBASELINE("HigherThanBaseline"),
        LOWERTHANBASELINE("LowerThanBaseline");

        private String value;

        private SuccessCriteriaEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SuccessCriteriaEnum fromValue(String value) {
            for (SuccessCriteriaEnum b : SuccessCriteriaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SuccessCriteriaEnum> {
            public void write(JsonWriter jsonWriter, SuccessCriteriaEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SuccessCriteriaEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SuccessCriteriaEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        PAGEVIEW("pageview"),
        CLICK("click"),
        CUSTOM("custom");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

