/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MetricV2Rep {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MetricV2Rep key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-metric", required=true, value="The metric key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MetricV2Rep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example metric", required=true, value="The metric name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricV2Rep kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="custom", required=true, value="The kind of event the metric tracks")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public MetricV2Rep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MetricV2Rep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"self\":{\"href\":\"/api/v2/metrics/my-project/my-metric\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public MetricV2Rep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricV2Rep metricV2Rep = (MetricV2Rep)o;
        return Objects.equals(this.key, metricV2Rep.key) && Objects.equals(this.name, metricV2Rep.name) && Objects.equals((Object)this.kind, (Object)metricV2Rep.kind) && Objects.equals(this.links, metricV2Rep.links) && Objects.equals(this.additionalProperties, metricV2Rep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.name, this.kind, this.links, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricV2Rep {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MetricV2Rep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
    }

    public static MetricV2Rep fromJson(String jsonString) throws IOException {
        return (MetricV2Rep)JSON.getGson().fromJson(jsonString, MetricV2Rep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricV2Rep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricV2Rep.class));
            return new TypeAdapter<MetricV2Rep>(){

                public void write(JsonWriter out, MetricV2Rep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricV2Rep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MetricV2Rep.validateJsonObject(jsonObj);
                    MetricV2Rep instance = (MetricV2Rep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        PAGEVIEW("pageview"),
        CLICK("click"),
        CUSTOM("custom");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

