/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.DefaultClientSideAvailabilityPost;
import com.launchdarkly.api.model.EnvironmentPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProjectPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_INCLUDE_IN_SNIPPET_BY_DEFAULT = "includeInSnippetByDefault";
    @SerializedName(value="includeInSnippetByDefault")
    private Boolean includeInSnippetByDefault;
    public static final String SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY = "defaultClientSideAvailability";
    @SerializedName(value="defaultClientSideAvailability")
    private DefaultClientSideAvailabilityPost defaultClientSideAvailability;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    private List<EnvironmentPost> environments = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ProjectPost name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Project", required=true, value="A human-friendly name for the project.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectPost key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="my-project", required=true, value="A unique key used to reference the project in your code.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ProjectPost includeInSnippetByDefault(Boolean includeInSnippetByDefault) {
        this.includeInSnippetByDefault = includeInSnippetByDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether or not flags created in this project are made available to the client-side JavaScript SDK by default.")
    public Boolean getIncludeInSnippetByDefault() {
        return this.includeInSnippetByDefault;
    }

    public void setIncludeInSnippetByDefault(Boolean includeInSnippetByDefault) {
        this.includeInSnippetByDefault = includeInSnippetByDefault;
    }

    public ProjectPost defaultClientSideAvailability(DefaultClientSideAvailabilityPost defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DefaultClientSideAvailabilityPost getDefaultClientSideAvailability() {
        return this.defaultClientSideAvailability;
    }

    public void setDefaultClientSideAvailability(DefaultClientSideAvailabilityPost defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
    }

    public ProjectPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ProjectPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"ops\"]", value="Tags for the project")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ProjectPost environments(List<EnvironmentPost> environments) {
        this.environments = environments;
        return this;
    }

    public ProjectPost addEnvironmentsItem(EnvironmentPost environmentsItem) {
        if (this.environments == null) {
            this.environments = new ArrayList<EnvironmentPost>();
        }
        this.environments.add(environmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Creates the provided environments for this project. If omitted default environments will be created instead.")
    public List<EnvironmentPost> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<EnvironmentPost> environments) {
        this.environments = environments;
    }

    public ProjectPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectPost projectPost = (ProjectPost)o;
        return Objects.equals(this.name, projectPost.name) && Objects.equals(this.key, projectPost.key) && Objects.equals(this.includeInSnippetByDefault, projectPost.includeInSnippetByDefault) && Objects.equals(this.defaultClientSideAvailability, projectPost.defaultClientSideAvailability) && Objects.equals(this.tags, projectPost.tags) && Objects.equals(this.environments, projectPost.environments) && Objects.equals(this.additionalProperties, projectPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.includeInSnippetByDefault, this.defaultClientSideAvailability, this.tags, this.environments, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    includeInSnippetByDefault: ").append(this.toIndentedString(this.includeInSnippetByDefault)).append("\n");
        sb.append("    defaultClientSideAvailability: ").append(this.toIndentedString(this.defaultClientSideAvailability)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ProjectPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY) != null) {
            DefaultClientSideAvailabilityPost.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        JsonArray jsonArrayenvironments = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENVIRONMENTS);
        if (jsonArrayenvironments != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENVIRONMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `environments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayenvironments.size(); ++i) {
                EnvironmentPost.validateJsonObject(jsonArrayenvironments.get(i).getAsJsonObject());
            }
        }
    }

    public static ProjectPost fromJson(String jsonString) throws IOException {
        return (ProjectPost)JSON.getGson().fromJson(jsonString, ProjectPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_IN_SNIPPET_BY_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ProjectPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProjectPost.class));
            return new TypeAdapter<ProjectPost>(){

                public void write(JsonWriter out, ProjectPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ProjectPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ProjectPost.validateJsonObject(jsonObj);
                    ProjectPost instance = (ProjectPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

