/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ExperimentAllocationRep;
import com.launchdarkly.api.model.WeightedVariation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Rollout {
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    private List<WeightedVariation> variations = new ArrayList<WeightedVariation>();
    public static final String SERIALIZED_NAME_EXPERIMENT_ALLOCATION = "experimentAllocation";
    @SerializedName(value="experimentAllocation")
    private ExperimentAllocationRep experimentAllocation;
    public static final String SERIALIZED_NAME_SEED = "seed";
    @SerializedName(value="seed")
    private Integer seed;
    public static final String SERIALIZED_NAME_BUCKET_BY = "bucketBy";
    @SerializedName(value="bucketBy")
    private String bucketBy;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Rollout variations(List<WeightedVariation> variations) {
        this.variations = variations;
        return this;
    }

    public Rollout addVariationsItem(WeightedVariation variationsItem) {
        this.variations.add(variationsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<WeightedVariation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<WeightedVariation> variations) {
        this.variations = variations;
    }

    public Rollout experimentAllocation(ExperimentAllocationRep experimentAllocation) {
        this.experimentAllocation = experimentAllocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExperimentAllocationRep getExperimentAllocation() {
        return this.experimentAllocation;
    }

    public void setExperimentAllocation(ExperimentAllocationRep experimentAllocation) {
        this.experimentAllocation = experimentAllocation;
    }

    public Rollout seed(Integer seed) {
        this.seed = seed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public Rollout bucketBy(String bucketBy) {
        this.bucketBy = bucketBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBucketBy() {
        return this.bucketBy;
    }

    public void setBucketBy(String bucketBy) {
        this.bucketBy = bucketBy;
    }

    public Rollout putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollout rollout = (Rollout)o;
        return Objects.equals(this.variations, rollout.variations) && Objects.equals(this.experimentAllocation, rollout.experimentAllocation) && Objects.equals(this.seed, rollout.seed) && Objects.equals(this.bucketBy, rollout.bucketBy) && Objects.equals(this.additionalProperties, rollout.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.variations, this.experimentAllocation, this.seed, this.bucketBy, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rollout {\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    experimentAllocation: ").append(this.toIndentedString(this.experimentAllocation)).append("\n");
        sb.append("    seed: ").append(this.toIndentedString(this.seed)).append("\n");
        sb.append("    bucketBy: ").append(this.toIndentedString(this.bucketBy)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Rollout is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS);
        if (jsonArrayvariations != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayvariations.size(); ++i) {
                WeightedVariation.validateJsonObject(jsonArrayvariations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENT_ALLOCATION) != null) {
            ExperimentAllocationRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENT_ALLOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUCKET_BY) != null && !jsonObj.get(SERIALIZED_NAME_BUCKET_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bucketBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUCKET_BY).toString()));
        }
    }

    public static Rollout fromJson(String jsonString) throws IOException {
        return (Rollout)JSON.getGson().fromJson(jsonString, Rollout.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_VARIATIONS);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENT_ALLOCATION);
        openapiFields.add(SERIALIZED_NAME_SEED);
        openapiFields.add(SERIALIZED_NAME_BUCKET_BY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VARIATIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Rollout.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Rollout.class));
            return new TypeAdapter<Rollout>(){

                public void write(JsonWriter out, Rollout value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Rollout read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Rollout.validateJsonObject(jsonObj);
                    Rollout instance = (Rollout)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

