/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberSummary;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Token {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_OWNER_ID = "ownerId";
    @SerializedName(value="ownerId")
    private String ownerId;
    public static final String SERIALIZED_NAME_MEMBER_ID = "memberId";
    @SerializedName(value="memberId")
    private String memberId;
    public static final String SERIALIZED_NAME_MEMBER = "_member";
    @SerializedName(value="_member")
    private MemberSummary member;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "lastModified";
    @SerializedName(value="lastModified")
    private Long lastModified;
    public static final String SERIALIZED_NAME_CUSTOM_ROLE_IDS = "customRoleIds";
    @SerializedName(value="customRoleIds")
    private List<String> customRoleIds = null;
    public static final String SERIALIZED_NAME_INLINE_ROLE = "inlineRole";
    @SerializedName(value="inlineRole")
    private List<Statement> inlineRole = null;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_SERVICE_TOKEN = "serviceToken";
    @SerializedName(value="serviceToken")
    private Boolean serviceToken;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_DEFAULT_API_VERSION = "defaultApiVersion";
    @SerializedName(value="defaultApiVersion")
    private Integer defaultApiVersion;
    public static final String SERIALIZED_NAME_LAST_USED = "lastUsed";
    @SerializedName(value="lastUsed")
    private Long lastUsed;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Token id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Token ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Token memberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Token member(MemberSummary member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberSummary getMember() {
        return this.member;
    }

    public void setMember(MemberSummary member) {
        this.member = member;
    }

    public Token name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example reader token", value="A human-friendly name for the access token")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Token description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A reader token used in testing and examples", value="A description for the access token")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Token creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Token lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Token customRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
        return this;
    }

    public Token addCustomRoleIdsItem(String customRoleIdsItem) {
        if (this.customRoleIds == null) {
            this.customRoleIds = new ArrayList<String>();
        }
        this.customRoleIds.add(customRoleIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="A list of custom role IDs to use as access limits for the access token")
    public List<String> getCustomRoleIds() {
        return this.customRoleIds;
    }

    public void setCustomRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
    }

    public Token inlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
        return this;
    }

    public Token addInlineRoleItem(Statement inlineRoleItem) {
        if (this.inlineRole == null) {
            this.inlineRole = new ArrayList<Statement>();
        }
        this.inlineRole.add(inlineRoleItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="An array of policy statements, with three attributes: effect, resources, actions. May be used in place of a built-in or custom role.")
    public List<Statement> getInlineRole() {
        return this.inlineRole;
    }

    public void setInlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
    }

    public Token role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="reader", value="Built-in role for the token")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Token token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234", value="Last four characters of the token value")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Token serviceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether this is a service token or a personal token")
    public Boolean getServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
    }

    public Token links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Token putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/tokens\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/tokens/61095542756dba551110ae21\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Token defaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20220603", value="The default API version for this token")
    public Integer getDefaultApiVersion() {
        return this.defaultApiVersion;
    }

    public void setDefaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
    }

    public Token lastUsed(Long lastUsed) {
        this.lastUsed = lastUsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Token putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.id, token.id) && Objects.equals(this.ownerId, token.ownerId) && Objects.equals(this.memberId, token.memberId) && Objects.equals(this.member, token.member) && Objects.equals(this.name, token.name) && Objects.equals(this.description, token.description) && Objects.equals(this.creationDate, token.creationDate) && Objects.equals(this.lastModified, token.lastModified) && Objects.equals(this.customRoleIds, token.customRoleIds) && Objects.equals(this.inlineRole, token.inlineRole) && Objects.equals(this.role, token.role) && Objects.equals(this.token, token.token) && Objects.equals(this.serviceToken, token.serviceToken) && Objects.equals(this.links, token.links) && Objects.equals(this.defaultApiVersion, token.defaultApiVersion) && Objects.equals(this.lastUsed, token.lastUsed) && Objects.equals(this.additionalProperties, token.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ownerId, this.memberId, this.member, this.name, this.description, this.creationDate, this.lastModified, this.customRoleIds, this.inlineRole, this.role, this.token, this.serviceToken, this.links, this.defaultApiVersion, this.lastUsed, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Token {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    memberId: ").append(this.toIndentedString(this.memberId)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    customRoleIds: ").append(this.toIndentedString(this.customRoleIds)).append("\n");
        sb.append("    inlineRole: ").append(this.toIndentedString(this.inlineRole)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    serviceToken: ").append(this.toIndentedString(this.serviceToken)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    defaultApiVersion: ").append(this.toIndentedString(this.defaultApiVersion)).append("\n");
        sb.append("    lastUsed: ").append(this.toIndentedString(this.lastUsed)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Token is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_ID) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ownerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMBER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MEMBER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `memberId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEMBER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER) != null) {
            MemberSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoleIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS).toString()));
        }
        JsonArray jsonArrayinlineRole = jsonObj.getAsJsonArray(SERIALIZED_NAME_INLINE_ROLE);
        if (jsonArrayinlineRole != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INLINE_ROLE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `inlineRole` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INLINE_ROLE).toString()));
            }
            for (int i = 0; i < jsonArrayinlineRole.size(); ++i) {
                Statement.validateJsonObject(jsonArrayinlineRole.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLE) != null && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN).toString()));
        }
    }

    public static Token fromJson(String jsonString) throws IOException {
        return (Token)JSON.getGson().fromJson(jsonString, Token.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_OWNER_ID);
        openapiFields.add(SERIALIZED_NAME_MEMBER_ID);
        openapiFields.add(SERIALIZED_NAME_MEMBER);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROLE_IDS);
        openapiFields.add(SERIALIZED_NAME_INLINE_ROLE);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_SERVICE_TOKEN);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_LAST_USED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_OWNER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_MEMBER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Token.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Token.class));
            return new TypeAdapter<Token>(){

                public void write(JsonWriter out, Token value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Token read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Token.validateJsonObject(jsonObj);
                    Token instance = (Token)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

