/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TreatmentParameterInput {
    public static final String SERIALIZED_NAME_FLAG_KEY = "flagKey";
    @SerializedName(value="flagKey")
    private String flagKey;
    public static final String SERIALIZED_NAME_VARIATION_ID = "variationId";
    @SerializedName(value="variationId")
    private String variationId;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TreatmentParameterInput flagKey(String flagKey) {
        this.flagKey = flagKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-flag-for-experiment", required=true, value="The flag key")
    public String getFlagKey() {
        return this.flagKey;
    }

    public void setFlagKey(String flagKey) {
        this.flagKey = flagKey;
    }

    public TreatmentParameterInput variationId(String variationId) {
        this.variationId = variationId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="e432f62b-55f6-49dd-a02f-eb24acf39d05", required=true, value="The ID of the flag variation")
    public String getVariationId() {
        return this.variationId;
    }

    public void setVariationId(String variationId) {
        this.variationId = variationId;
    }

    public TreatmentParameterInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreatmentParameterInput treatmentParameterInput = (TreatmentParameterInput)o;
        return Objects.equals(this.flagKey, treatmentParameterInput.flagKey) && Objects.equals(this.variationId, treatmentParameterInput.variationId) && Objects.equals(this.additionalProperties, treatmentParameterInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.flagKey, this.variationId, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreatmentParameterInput {\n");
        sb.append("    flagKey: ").append(this.toIndentedString(this.flagKey)).append("\n");
        sb.append("    variationId: ").append(this.toIndentedString(this.variationId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TreatmentParameterInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FLAG_KEY) != null && !jsonObj.get(SERIALIZED_NAME_FLAG_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `flagKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FLAG_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_VARIATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `variationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATION_ID).toString()));
        }
    }

    public static TreatmentParameterInput fromJson(String jsonString) throws IOException {
        return (TreatmentParameterInput)JSON.getGson().fromJson(jsonString, TreatmentParameterInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FLAG_KEY);
        openapiFields.add(SERIALIZED_NAME_VARIATION_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FLAG_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_VARIATION_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TreatmentParameterInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TreatmentParameterInput.class));
            return new TypeAdapter<TreatmentParameterInput>(){

                public void write(JsonWriter out, TreatmentParameterInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TreatmentParameterInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TreatmentParameterInput.validateJsonObject(jsonObj);
                    TreatmentParameterInput instance = (TreatmentParameterInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

