/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.FlagListingRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.SegmentMetadata;
import com.launchdarkly.api.model.UserSegmentRule;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserSegment {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_INCLUDED = "included";
    @SerializedName(value="included")
    private List<String> included = null;
    public static final String SERIALIZED_NAME_EXCLUDED = "excluded";
    @SerializedName(value="excluded")
    private List<String> excluded = null;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<UserSegmentRule> rules = new ArrayList<UserSegmentRule>();
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_DELETED = "deleted";
    @SerializedName(value="deleted")
    private Boolean deleted;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_FLAGS = "_flags";
    @SerializedName(value="_flags")
    private List<FlagListingRep> flags = null;
    public static final String SERIALIZED_NAME_UNBOUNDED = "unbounded";
    @SerializedName(value="unbounded")
    private Boolean unbounded;
    public static final String SERIALIZED_NAME_GENERATION = "generation";
    @SerializedName(value="generation")
    private Integer generation;
    public static final String SERIALIZED_NAME_UNBOUNDED_METADATA = "_unboundedMetadata";
    @SerializedName(value="_unboundedMetadata")
    private SegmentMetadata unboundedMetadata;
    public static final String SERIALIZED_NAME_EXTERNAL = "_external";
    @SerializedName(value="_external")
    private String external;
    public static final String SERIALIZED_NAME_EXTERNAL_LINK = "_externalLink";
    @SerializedName(value="_externalLink")
    private String externalLink;
    public static final String SERIALIZED_NAME_IMPORT_IN_PROGRESS = "_importInProgress";
    @SerializedName(value="_importInProgress")
    private Boolean importInProgress;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UserSegment name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example segment", required=true, value="A human-friendly name for the segment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserSegment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Bundle our sample users together", value="A description of the segment's purpose. Defaults to <code>null</code> and is omitted in the response if not provided.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserSegment tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UserSegment addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"testing\"]", required=true, value="Tags for the segment. Defaults to an empty array.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UserSegment creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public UserSegment key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-segment", required=true, value="A unique key used to reference the segment")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserSegment included(List<String> included) {
        this.included = included;
        return this;
    }

    public UserSegment addIncludedItem(String includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<String>();
        }
        this.included.add(includedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-user-key\"]", value="An array of user keys for included users. Included users are always segment members, regardless of segment rules. For Big Segments this array is either empty or omitted.")
    public List<String> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<String> included) {
        this.included = included;
    }

    public UserSegment excluded(List<String> excluded) {
        this.excluded = excluded;
        return this;
    }

    public UserSegment addExcludedItem(String excludedItem) {
        if (this.excluded == null) {
            this.excluded = new ArrayList<String>();
        }
        this.excluded.add(excludedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-user-to-exclude\"]", value="An array of user keys for excluded users. Segment rules bypass excluded users, so they will never be included based on rules. Excluded users may still be included explicitly. This value is omitted for Big Segments.")
    public List<String> getExcluded() {
        return this.excluded;
    }

    public void setExcluded(List<String> excluded) {
        this.excluded = excluded;
    }

    public UserSegment links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public UserSegment putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public UserSegment rules(List<UserSegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    public UserSegment addRulesItem(UserSegmentRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[{\"_id\":\"1234a56b7c89d012345e678f\",\"clauses\":[{\"_id\":\"12ab3c45de678910fab12345\",\"attribute\":\"email\",\"negate\":false,\"op\":\"endsWith\",\"values\":[\".edu\"]}]}]", required=true, value="An array of the targeting rules for this segment.")
    public List<UserSegmentRule> getRules() {
        return this.rules;
    }

    public void setRules(List<UserSegmentRule> rules) {
        this.rules = rules;
    }

    public UserSegment version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Version of the segment")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public UserSegment deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Whether the segment has been deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public UserSegment access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public UserSegment flags(List<FlagListingRep> flags) {
        this.flags = flags;
        return this;
    }

    public UserSegment addFlagsItem(FlagListingRep flagsItem) {
        if (this.flags == null) {
            this.flags = new ArrayList<FlagListingRep>();
        }
        this.flags.add(flagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<FlagListingRep> getFlags() {
        return this.flags;
    }

    public void setFlags(List<FlagListingRep> flags) {
        this.flags = flags;
    }

    public UserSegment unbounded(Boolean unbounded) {
        this.unbounded = unbounded;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether this is a standard segment (<code>false</code>) or a Big Segment (<code>true</code>). If omitted, the segment is a standard segment.")
    public Boolean getUnbounded() {
        return this.unbounded;
    }

    public void setUnbounded(Boolean unbounded) {
        this.unbounded = unbounded;
    }

    public UserSegment generation(Integer generation) {
        this.generation = generation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="For Big Segments, how many times this segment has been created")
    public Integer getGeneration() {
        return this.generation;
    }

    public void setGeneration(Integer generation) {
        this.generation = generation;
    }

    public UserSegment unboundedMetadata(SegmentMetadata unboundedMetadata) {
        this.unboundedMetadata = unboundedMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SegmentMetadata getUnboundedMetadata() {
        return this.unboundedMetadata;
    }

    public void setUnboundedMetadata(SegmentMetadata unboundedMetadata) {
        this.unboundedMetadata = unboundedMetadata;
    }

    public UserSegment external(String external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="amplitude", value="The external data store backing this segment. Only applies to Big Segments.")
    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public UserSegment externalLink(String externalLink) {
        this.externalLink = externalLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://analytics.amplitude.com/org/1234/cohort/123abc", value="The URL for the external data store backing this segment. Only applies to Big Segments.")
    public String getExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(String externalLink) {
        this.externalLink = externalLink;
    }

    public UserSegment importInProgress(Boolean importInProgress) {
        this.importInProgress = importInProgress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether an import is currently in progress for the specified segment. Only applies to Big Segments.")
    public Boolean getImportInProgress() {
        return this.importInProgress;
    }

    public void setImportInProgress(Boolean importInProgress) {
        this.importInProgress = importInProgress;
    }

    public UserSegment putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSegment userSegment = (UserSegment)o;
        return Objects.equals(this.name, userSegment.name) && Objects.equals(this.description, userSegment.description) && Objects.equals(this.tags, userSegment.tags) && Objects.equals(this.creationDate, userSegment.creationDate) && Objects.equals(this.key, userSegment.key) && Objects.equals(this.included, userSegment.included) && Objects.equals(this.excluded, userSegment.excluded) && Objects.equals(this.links, userSegment.links) && Objects.equals(this.rules, userSegment.rules) && Objects.equals(this.version, userSegment.version) && Objects.equals(this.deleted, userSegment.deleted) && Objects.equals(this.access, userSegment.access) && Objects.equals(this.flags, userSegment.flags) && Objects.equals(this.unbounded, userSegment.unbounded) && Objects.equals(this.generation, userSegment.generation) && Objects.equals(this.unboundedMetadata, userSegment.unboundedMetadata) && Objects.equals(this.external, userSegment.external) && Objects.equals(this.externalLink, userSegment.externalLink) && Objects.equals(this.importInProgress, userSegment.importInProgress) && Objects.equals(this.additionalProperties, userSegment.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.tags, this.creationDate, this.key, this.included, this.excluded, this.links, this.rules, this.version, this.deleted, this.access, this.flags, this.unbounded, this.generation, this.unboundedMetadata, this.external, this.externalLink, this.importInProgress, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSegment {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    excluded: ").append(this.toIndentedString(this.excluded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    unbounded: ").append(this.toIndentedString(this.unbounded)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    unboundedMetadata: ").append(this.toIndentedString(this.unboundedMetadata)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    externalLink: ").append(this.toIndentedString(this.externalLink)).append("\n");
        sb.append("    importInProgress: ").append(this.toIndentedString(this.importInProgress)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayflags;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UserSegment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INCLUDED) != null && !jsonObj.get(SERIALIZED_NAME_INCLUDED).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `included` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INCLUDED).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDED) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDED).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `excluded` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDED).toString()));
        }
        JsonArray jsonArrayrules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RULES);
        if (jsonArrayrules != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `rules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULES).toString()));
            }
            for (int i = 0; i < jsonArrayrules.size(); ++i) {
                UserSegmentRule.validateJsonObject(jsonArrayrules.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if ((jsonArrayflags = jsonObj.getAsJsonArray(SERIALIZED_NAME_FLAGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FLAGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `_flags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FLAGS).toString()));
            }
            for (int i = 0; i < jsonArrayflags.size(); ++i) {
                FlagListingRep.validateJsonObject(jsonArrayflags.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_UNBOUNDED_METADATA) != null) {
            SegmentMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UNBOUNDED_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_external` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_LINK) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_externalLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_LINK).toString()));
        }
    }

    public static UserSegment fromJson(String jsonString) throws IOException {
        return (UserSegment)JSON.getGson().fromJson(jsonString, UserSegment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_INCLUDED);
        openapiFields.add(SERIALIZED_NAME_EXCLUDED);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_RULES);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_DELETED);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_FLAGS);
        openapiFields.add(SERIALIZED_NAME_UNBOUNDED);
        openapiFields.add(SERIALIZED_NAME_GENERATION);
        openapiFields.add(SERIALIZED_NAME_UNBOUNDED_METADATA);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_LINK);
        openapiFields.add(SERIALIZED_NAME_IMPORT_IN_PROGRESS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_RULES);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_DELETED);
        openapiRequiredFields.add(SERIALIZED_NAME_GENERATION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UserSegment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserSegment.class));
            return new TypeAdapter<UserSegment>(){

                public void write(JsonWriter out, UserSegment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public UserSegment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UserSegment.validateJsonObject(jsonObj);
                    UserSegment instance = (UserSegment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

