/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.SdkListRep;
import com.launchdarkly.api.model.SdkVersionListRep;
import com.launchdarkly.api.model.SeriesIntervalsRep;
import com.launchdarkly.api.model.SeriesListRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AccountUsageBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountUsageBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountUsageBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getEvaluationsUsageCall(String projectKey, String environmentKey, String featureFlagKey, String from, String to, String tz, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/evaluations/{projectKey}/{environmentKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (tz != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tz", tz));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEvaluationsUsageValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, String from, String to, String tz, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getEvaluationsUsage(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getEvaluationsUsage(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getEvaluationsUsage(Async)");
        }
        Call localVarCall = this.getEvaluationsUsageCall(projectKey, environmentKey, featureFlagKey, from, to, tz, _callback);
        return localVarCall;
    }

    public SeriesListRep getEvaluationsUsage(String projectKey, String environmentKey, String featureFlagKey, String from, String to, String tz) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getEvaluationsUsageWithHttpInfo(projectKey, environmentKey, featureFlagKey, from, to, tz);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getEvaluationsUsageWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, String from, String to, String tz) throws ApiException {
        Call localVarCall = this.getEvaluationsUsageValidateBeforeCall(projectKey, environmentKey, featureFlagKey, from, to, tz, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEvaluationsUsageAsync(String projectKey, String environmentKey, String featureFlagKey, String from, String to, String tz, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getEvaluationsUsageValidateBeforeCall(projectKey, environmentKey, featureFlagKey, from, to, tz, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEventsUsageCall(String type, String from, String to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/events/{type}".replaceAll("\\{type\\}", this.localVarApiClient.escapeString(type.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEventsUsageValidateBeforeCall(String type, String from, String to, ApiCallback _callback) throws ApiException {
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getEventsUsage(Async)");
        }
        Call localVarCall = this.getEventsUsageCall(type, from, to, _callback);
        return localVarCall;
    }

    public SeriesListRep getEventsUsage(String type, String from, String to) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getEventsUsageWithHttpInfo(type, from, to);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getEventsUsageWithHttpInfo(String type, String from, String to) throws ApiException {
        Call localVarCall = this.getEventsUsageValidateBeforeCall(type, from, to, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEventsUsageAsync(String type, String from, String to, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getEventsUsageValidateBeforeCall(type, from, to, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentationKeysUsageCall(String from, String to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/experimentation-keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentationKeysUsageValidateBeforeCall(String from, String to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExperimentationKeysUsageCall(from, to, _callback);
        return localVarCall;
    }

    public SeriesIntervalsRep getExperimentationKeysUsage(String from, String to) throws ApiException {
        ApiResponse<SeriesIntervalsRep> localVarResp = this.getExperimentationKeysUsageWithHttpInfo(from, to);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesIntervalsRep> getExperimentationKeysUsageWithHttpInfo(String from, String to) throws ApiException {
        Call localVarCall = this.getExperimentationKeysUsageValidateBeforeCall(from, to, null);
        Type localVarReturnType = new TypeToken<SeriesIntervalsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentationKeysUsageAsync(String from, String to, ApiCallback<SeriesIntervalsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentationKeysUsageValidateBeforeCall(from, to, _callback);
        Type localVarReturnType = new TypeToken<SeriesIntervalsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentationUnitsUsageCall(String from, String to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/experimentation-units";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentationUnitsUsageValidateBeforeCall(String from, String to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExperimentationUnitsUsageCall(from, to, _callback);
        return localVarCall;
    }

    public SeriesIntervalsRep getExperimentationUnitsUsage(String from, String to) throws ApiException {
        ApiResponse<SeriesIntervalsRep> localVarResp = this.getExperimentationUnitsUsageWithHttpInfo(from, to);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesIntervalsRep> getExperimentationUnitsUsageWithHttpInfo(String from, String to) throws ApiException {
        Call localVarCall = this.getExperimentationUnitsUsageValidateBeforeCall(from, to, null);
        Type localVarReturnType = new TypeToken<SeriesIntervalsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentationUnitsUsageAsync(String from, String to, ApiCallback<SeriesIntervalsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentationUnitsUsageValidateBeforeCall(from, to, _callback);
        Type localVarReturnType = new TypeToken<SeriesIntervalsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMauSdksByTypeCall(String from, String to, String sdktype, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/mau/sdks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (sdktype != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sdktype", sdktype));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMauSdksByTypeValidateBeforeCall(String from, String to, String sdktype, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getMauSdksByTypeCall(from, to, sdktype, _callback);
        return localVarCall;
    }

    public SdkListRep getMauSdksByType(String from, String to, String sdktype) throws ApiException {
        ApiResponse<SdkListRep> localVarResp = this.getMauSdksByTypeWithHttpInfo(from, to, sdktype);
        return localVarResp.getData();
    }

    public ApiResponse<SdkListRep> getMauSdksByTypeWithHttpInfo(String from, String to, String sdktype) throws ApiException {
        Call localVarCall = this.getMauSdksByTypeValidateBeforeCall(from, to, sdktype, null);
        Type localVarReturnType = new TypeToken<SdkListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMauSdksByTypeAsync(String from, String to, String sdktype, ApiCallback<SdkListRep> _callback) throws ApiException {
        Call localVarCall = this.getMauSdksByTypeValidateBeforeCall(from, to, sdktype, _callback);
        Type localVarReturnType = new TypeToken<SdkListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMauUsageCall(String from, String to, String project, String environment, String sdktype, String sdk, String anonymous, String groupby, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/mau";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (project != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("project", project));
        }
        if (environment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environment", environment));
        }
        if (sdktype != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sdktype", sdktype));
        }
        if (sdk != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sdk", sdk));
        }
        if (anonymous != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("anonymous", anonymous));
        }
        if (groupby != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupby", groupby));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMauUsageValidateBeforeCall(String from, String to, String project, String environment, String sdktype, String sdk, String anonymous, String groupby, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getMauUsageCall(from, to, project, environment, sdktype, sdk, anonymous, groupby, _callback);
        return localVarCall;
    }

    public SeriesListRep getMauUsage(String from, String to, String project, String environment, String sdktype, String sdk, String anonymous, String groupby) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getMauUsageWithHttpInfo(from, to, project, environment, sdktype, sdk, anonymous, groupby);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getMauUsageWithHttpInfo(String from, String to, String project, String environment, String sdktype, String sdk, String anonymous, String groupby) throws ApiException {
        Call localVarCall = this.getMauUsageValidateBeforeCall(from, to, project, environment, sdktype, sdk, anonymous, groupby, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMauUsageAsync(String from, String to, String project, String environment, String sdktype, String sdk, String anonymous, String groupby, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getMauUsageValidateBeforeCall(from, to, project, environment, sdktype, sdk, anonymous, groupby, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMauUsageByCategoryCall(String from, String to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/mau/bycategory";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMauUsageByCategoryValidateBeforeCall(String from, String to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getMauUsageByCategoryCall(from, to, _callback);
        return localVarCall;
    }

    public SeriesListRep getMauUsageByCategory(String from, String to) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getMauUsageByCategoryWithHttpInfo(from, to);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getMauUsageByCategoryWithHttpInfo(String from, String to) throws ApiException {
        Call localVarCall = this.getMauUsageByCategoryValidateBeforeCall(from, to, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMauUsageByCategoryAsync(String from, String to, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getMauUsageByCategoryValidateBeforeCall(from, to, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStreamUsageCall(String source, String from, String to, String tz, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/streams/{source}".replaceAll("\\{source\\}", this.localVarApiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (tz != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tz", tz));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStreamUsageValidateBeforeCall(String source, String from, String to, String tz, ApiCallback _callback) throws ApiException {
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling getStreamUsage(Async)");
        }
        Call localVarCall = this.getStreamUsageCall(source, from, to, tz, _callback);
        return localVarCall;
    }

    public SeriesListRep getStreamUsage(String source, String from, String to, String tz) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getStreamUsageWithHttpInfo(source, from, to, tz);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getStreamUsageWithHttpInfo(String source, String from, String to, String tz) throws ApiException {
        Call localVarCall = this.getStreamUsageValidateBeforeCall(source, from, to, tz, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStreamUsageAsync(String source, String from, String to, String tz, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getStreamUsageValidateBeforeCall(source, from, to, tz, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStreamUsageBySdkVersionCall(String source, String from, String to, String tz, String sdk, String version, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/streams/{source}/bysdkversion".replaceAll("\\{source\\}", this.localVarApiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (tz != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tz", tz));
        }
        if (sdk != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sdk", sdk));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStreamUsageBySdkVersionValidateBeforeCall(String source, String from, String to, String tz, String sdk, String version, ApiCallback _callback) throws ApiException {
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling getStreamUsageBySdkVersion(Async)");
        }
        Call localVarCall = this.getStreamUsageBySdkVersionCall(source, from, to, tz, sdk, version, _callback);
        return localVarCall;
    }

    public SeriesListRep getStreamUsageBySdkVersion(String source, String from, String to, String tz, String sdk, String version) throws ApiException {
        ApiResponse<SeriesListRep> localVarResp = this.getStreamUsageBySdkVersionWithHttpInfo(source, from, to, tz, sdk, version);
        return localVarResp.getData();
    }

    public ApiResponse<SeriesListRep> getStreamUsageBySdkVersionWithHttpInfo(String source, String from, String to, String tz, String sdk, String version) throws ApiException {
        Call localVarCall = this.getStreamUsageBySdkVersionValidateBeforeCall(source, from, to, tz, sdk, version, null);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStreamUsageBySdkVersionAsync(String source, String from, String to, String tz, String sdk, String version, ApiCallback<SeriesListRep> _callback) throws ApiException {
        Call localVarCall = this.getStreamUsageBySdkVersionValidateBeforeCall(source, from, to, tz, sdk, version, _callback);
        Type localVarReturnType = new TypeToken<SeriesListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStreamUsageSdkversionCall(String source, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/usage/streams/{source}/sdkversions".replaceAll("\\{source\\}", this.localVarApiClient.escapeString(source.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStreamUsageSdkversionValidateBeforeCall(String source, ApiCallback _callback) throws ApiException {
        if (source == null) {
            throw new ApiException("Missing the required parameter 'source' when calling getStreamUsageSdkversion(Async)");
        }
        Call localVarCall = this.getStreamUsageSdkversionCall(source, _callback);
        return localVarCall;
    }

    public SdkVersionListRep getStreamUsageSdkversion(String source) throws ApiException {
        ApiResponse<SdkVersionListRep> localVarResp = this.getStreamUsageSdkversionWithHttpInfo(source);
        return localVarResp.getData();
    }

    public ApiResponse<SdkVersionListRep> getStreamUsageSdkversionWithHttpInfo(String source) throws ApiException {
        Call localVarCall = this.getStreamUsageSdkversionValidateBeforeCall(source, null);
        Type localVarReturnType = new TypeToken<SdkVersionListRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStreamUsageSdkversionAsync(String source, ApiCallback<SdkVersionListRep> _callback) throws ApiException {
        Call localVarCall = this.getStreamUsageSdkversionValidateBeforeCall(source, _callback);
        Type localVarReturnType = new TypeToken<SdkVersionListRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

