/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Integration;
import com.launchdarkly.api.model.Integrations;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.SubscriptionPost;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class IntegrationAuditLogSubscriptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IntegrationAuditLogSubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationAuditLogSubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSubscriptionCall(String integrationKey, SubscriptionPost subscriptionPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubscriptionPost localVarPostBody = subscriptionPost;
        String localVarPath = "/api/v2/integrations/{integrationKey}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSubscriptionValidateBeforeCall(String integrationKey, SubscriptionPost subscriptionPost, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling createSubscription(Async)");
        }
        if (subscriptionPost == null) {
            throw new ApiException("Missing the required parameter 'subscriptionPost' when calling createSubscription(Async)");
        }
        Call localVarCall = this.createSubscriptionCall(integrationKey, subscriptionPost, _callback);
        return localVarCall;
    }

    public Integration createSubscription(String integrationKey, SubscriptionPost subscriptionPost) throws ApiException {
        ApiResponse<Integration> localVarResp = this.createSubscriptionWithHttpInfo(integrationKey, subscriptionPost);
        return localVarResp.getData();
    }

    public ApiResponse<Integration> createSubscriptionWithHttpInfo(String integrationKey, SubscriptionPost subscriptionPost) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(integrationKey, subscriptionPost, null);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSubscriptionAsync(String integrationKey, SubscriptionPost subscriptionPost, ApiCallback<Integration> _callback) throws ApiException {
        Call localVarCall = this.createSubscriptionValidateBeforeCall(integrationKey, subscriptionPost, _callback);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSubscriptionCall(String integrationKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/{integrationKey}/{id}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSubscriptionValidateBeforeCall(String integrationKey, String id, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling deleteSubscription(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteSubscription(Async)");
        }
        Call localVarCall = this.deleteSubscriptionCall(integrationKey, id, _callback);
        return localVarCall;
    }

    public void deleteSubscription(String integrationKey, String id) throws ApiException {
        this.deleteSubscriptionWithHttpInfo(integrationKey, id);
    }

    public ApiResponse<Void> deleteSubscriptionWithHttpInfo(String integrationKey, String id) throws ApiException {
        Call localVarCall = this.deleteSubscriptionValidateBeforeCall(integrationKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSubscriptionAsync(String integrationKey, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSubscriptionValidateBeforeCall(integrationKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getSubscriptionByIDCall(String integrationKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/{integrationKey}/{id}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionByIDValidateBeforeCall(String integrationKey, String id, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getSubscriptionByID(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSubscriptionByID(Async)");
        }
        Call localVarCall = this.getSubscriptionByIDCall(integrationKey, id, _callback);
        return localVarCall;
    }

    public Integration getSubscriptionByID(String integrationKey, String id) throws ApiException {
        ApiResponse<Integration> localVarResp = this.getSubscriptionByIDWithHttpInfo(integrationKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<Integration> getSubscriptionByIDWithHttpInfo(String integrationKey, String id) throws ApiException {
        Call localVarCall = this.getSubscriptionByIDValidateBeforeCall(integrationKey, id, null);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSubscriptionByIDAsync(String integrationKey, String id, ApiCallback<Integration> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionByIDValidateBeforeCall(integrationKey, id, _callback);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSubscriptionsCall(String integrationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/{integrationKey}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSubscriptionsValidateBeforeCall(String integrationKey, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getSubscriptions(Async)");
        }
        Call localVarCall = this.getSubscriptionsCall(integrationKey, _callback);
        return localVarCall;
    }

    public Integrations getSubscriptions(String integrationKey) throws ApiException {
        ApiResponse<Integrations> localVarResp = this.getSubscriptionsWithHttpInfo(integrationKey);
        return localVarResp.getData();
    }

    public ApiResponse<Integrations> getSubscriptionsWithHttpInfo(String integrationKey) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(integrationKey, null);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSubscriptionsAsync(String integrationKey, ApiCallback<Integrations> _callback) throws ApiException {
        Call localVarCall = this.getSubscriptionsValidateBeforeCall(integrationKey, _callback);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSubscriptionCall(String integrationKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/integrations/{integrationKey}/{id}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSubscriptionValidateBeforeCall(String integrationKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling updateSubscription(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSubscription(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling updateSubscription(Async)");
        }
        Call localVarCall = this.updateSubscriptionCall(integrationKey, id, patchOperation, _callback);
        return localVarCall;
    }

    public Integration updateSubscription(String integrationKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<Integration> localVarResp = this.updateSubscriptionWithHttpInfo(integrationKey, id, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<Integration> updateSubscriptionWithHttpInfo(String integrationKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.updateSubscriptionValidateBeforeCall(integrationKey, id, patchOperation, null);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSubscriptionAsync(String integrationKey, String id, List<PatchOperation> patchOperation, ApiCallback<Integration> _callback) throws ApiException {
        Call localVarCall = this.updateSubscriptionValidateBeforeCall(integrationKey, id, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

