/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Client {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "_accountId";
    @SerializedName(value="_accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_CLIENT_ID = "_clientId";
    @SerializedName(value="_clientId")
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "_clientSecret";
    @SerializedName(value="_clientSecret")
    private String clientSecret;
    public static final String SERIALIZED_NAME_REDIRECT_URI = "redirectUri";
    @SerializedName(value="redirectUri")
    private String redirectUri;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Client links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Client putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/oauth/clients\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/oauth/clients/50666563-9144-4125-b822-33f308227e45\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Client name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Client name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Client description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Client accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The account ID the client is registered under")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Client clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The client's unique ID")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Client clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client secret. This will only be shown upon creation.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Client redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The client's redirect URI")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Client creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Client putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.links, client.links) && Objects.equals(this.name, client.name) && Objects.equals(this.description, client.description) && Objects.equals(this.accountId, client.accountId) && Objects.equals(this.clientId, client.clientId) && Objects.equals(this.clientSecret, client.clientSecret) && Objects.equals(this.redirectUri, client.redirectUri) && Objects.equals(this.creationDate, client.creationDate) && Objects.equals(this.additionalProperties, client.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.name, this.description, this.accountId, this.clientId, this.clientSecret, this.redirectUri, this.creationDate, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Client is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_accountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_clientId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_clientSecret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_SECRET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_URI) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `redirectUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_URI).toString()));
        }
    }

    public static Client fromJson(String jsonString) throws IOException {
        return (Client)JSON.getGson().fromJson(jsonString, Client.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SECRET);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_URI);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_REDIRECT_URI);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Client.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Client.class));
            return new TypeAdapter<Client>(){

                public void write(JsonWriter out, Client value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Client read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Client.validateJsonObject(jsonObj);
                    Client instance = (Client)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

