/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ContextInstanceSegmentMembership {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_UNBOUNDED = "unbounded";
    @SerializedName(value="unbounded")
    private Boolean unbounded;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private String external;
    public static final String SERIALIZED_NAME_IS_MEMBER = "isMember";
    @SerializedName(value="isMember")
    private Boolean isMember;
    public static final String SERIALIZED_NAME_IS_INDIVIDUALLY_TARGETED = "isIndividuallyTargeted";
    @SerializedName(value="isIndividuallyTargeted")
    private Boolean isIndividuallyTargeted;
    public static final String SERIALIZED_NAME_IS_RULE_TARGETED = "isRuleTargeted";
    @SerializedName(value="isRuleTargeted")
    private Boolean isRuleTargeted;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContextInstanceSegmentMembership name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Segment Name", required=true, value="A human-friendly name for the segment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContextInstanceSegmentMembership key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="segment-key-123abc", required=true, value="A unique key used to reference the segment")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ContextInstanceSegmentMembership description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Segment description", required=true, value="A description of the segment's purpose")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContextInstanceSegmentMembership unbounded(Boolean unbounded) {
        this.unbounded = unbounded;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Whether this is an unbounded segment. Unbounded segments, also called Big Segments, may be list-based segments with more than 15,000 entries, or synced segments.")
    public Boolean getUnbounded() {
        return this.unbounded;
    }

    public void setUnbounded(Boolean unbounded) {
        this.unbounded = unbounded;
    }

    public ContextInstanceSegmentMembership external(String external) {
        this.external = external;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://amplitude.com/myCohort", required=true, value="If the segment is a synced segment, the name of the external source")
    public String getExternal() {
        return this.external;
    }

    public void setExternal(String external) {
        this.external = external;
    }

    public ContextInstanceSegmentMembership isMember(Boolean isMember) {
        this.isMember = isMember;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether the context is a member of this segment, either by explicit inclusion or by rule matching")
    public Boolean getIsMember() {
        return this.isMember;
    }

    public void setIsMember(Boolean isMember) {
        this.isMember = isMember;
    }

    public ContextInstanceSegmentMembership isIndividuallyTargeted(Boolean isIndividuallyTargeted) {
        this.isIndividuallyTargeted = isIndividuallyTargeted;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether the context is explicitly included in this segment")
    public Boolean getIsIndividuallyTargeted() {
        return this.isIndividuallyTargeted;
    }

    public void setIsIndividuallyTargeted(Boolean isIndividuallyTargeted) {
        this.isIndividuallyTargeted = isIndividuallyTargeted;
    }

    public ContextInstanceSegmentMembership isRuleTargeted(Boolean isRuleTargeted) {
        this.isRuleTargeted = isRuleTargeted;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Whether the context is captured by this segment's rules. The value of this field is undefined if the context is also explicitly included (<code>isIndividuallyTargeted</code> is <code>true</code>).")
    public Boolean getIsRuleTargeted() {
        return this.isRuleTargeted;
    }

    public void setIsRuleTargeted(Boolean isRuleTargeted) {
        this.isRuleTargeted = isRuleTargeted;
    }

    public ContextInstanceSegmentMembership links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ContextInstanceSegmentMembership putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ContextInstanceSegmentMembership putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextInstanceSegmentMembership contextInstanceSegmentMembership = (ContextInstanceSegmentMembership)o;
        return Objects.equals(this.name, contextInstanceSegmentMembership.name) && Objects.equals(this.key, contextInstanceSegmentMembership.key) && Objects.equals(this.description, contextInstanceSegmentMembership.description) && Objects.equals(this.unbounded, contextInstanceSegmentMembership.unbounded) && Objects.equals(this.external, contextInstanceSegmentMembership.external) && Objects.equals(this.isMember, contextInstanceSegmentMembership.isMember) && Objects.equals(this.isIndividuallyTargeted, contextInstanceSegmentMembership.isIndividuallyTargeted) && Objects.equals(this.isRuleTargeted, contextInstanceSegmentMembership.isRuleTargeted) && Objects.equals(this.links, contextInstanceSegmentMembership.links) && Objects.equals(this.additionalProperties, contextInstanceSegmentMembership.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.description, this.unbounded, this.external, this.isMember, this.isIndividuallyTargeted, this.isRuleTargeted, this.links, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContextInstanceSegmentMembership {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    unbounded: ").append(this.toIndentedString(this.unbounded)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    isMember: ").append(this.toIndentedString(this.isMember)).append("\n");
        sb.append("    isIndividuallyTargeted: ").append(this.toIndentedString(this.isIndividuallyTargeted)).append("\n");
        sb.append("    isRuleTargeted: ").append(this.toIndentedString(this.isRuleTargeted)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContextInstanceSegmentMembership is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `external` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL).toString()));
        }
    }

    public static ContextInstanceSegmentMembership fromJson(String jsonString) throws IOException {
        return (ContextInstanceSegmentMembership)JSON.getGson().fromJson(jsonString, ContextInstanceSegmentMembership.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_UNBOUNDED);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL);
        openapiFields.add(SERIALIZED_NAME_IS_MEMBER);
        openapiFields.add(SERIALIZED_NAME_IS_INDIVIDUALLY_TARGETED);
        openapiFields.add(SERIALIZED_NAME_IS_RULE_TARGETED);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_UNBOUNDED);
        openapiRequiredFields.add(SERIALIZED_NAME_EXTERNAL);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_MEMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_INDIVIDUALLY_TARGETED);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_RULE_TARGETED);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ContextInstanceSegmentMembership.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContextInstanceSegmentMembership.class));
            return new TypeAdapter<ContextInstanceSegmentMembership>(){

                public void write(JsonWriter out, ContextInstanceSegmentMembership value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ContextInstanceSegmentMembership read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContextInstanceSegmentMembership.validateJsonObject(jsonObj);
                    ContextInstanceSegmentMembership instance = (ContextInstanceSegmentMembership)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

