/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.DependentMetricOrMetricGroupRep;
import com.launchdarkly.api.model.FlagRep;
import com.launchdarkly.api.model.MetricV2Rep;
import com.launchdarkly.api.model.TreatmentRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DesignRep {
    public static final String SERIALIZED_NAME_HYPOTHESIS = "hypothesis";
    @SerializedName(value="hypothesis")
    private String hypothesis;
    public static final String SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC = "canReshuffleTraffic";
    @SerializedName(value="canReshuffleTraffic")
    private Boolean canReshuffleTraffic;
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    private Map<String, FlagRep> flags = null;
    public static final String SERIALIZED_NAME_PRIMARY_METRIC = "primaryMetric";
    @SerializedName(value="primaryMetric")
    private DependentMetricOrMetricGroupRep primaryMetric;
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNIT = "randomizationUnit";
    @SerializedName(value="randomizationUnit")
    private String randomizationUnit;
    public static final String SERIALIZED_NAME_TREATMENTS = "treatments";
    @SerializedName(value="treatments")
    private List<TreatmentRep> treatments = null;
    public static final String SERIALIZED_NAME_SECONDARY_METRICS = "secondaryMetrics";
    @SerializedName(value="secondaryMetrics")
    private List<MetricV2Rep> secondaryMetrics = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DesignRep hypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="The new button placement will increase conversion", required=true, value="The expected outcome of this experiment")
    public String getHypothesis() {
        return this.hypothesis;
    }

    public void setHypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
    }

    public DesignRep canReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the experiment can reassign traffic to different variations when you increase or decrease the traffic in your experiment audience (true) or keep all traffic assigned to its initial variation (false).")
    public Boolean getCanReshuffleTraffic() {
        return this.canReshuffleTraffic;
    }

    public void setCanReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
    }

    public DesignRep flags(Map<String, FlagRep> flags) {
        this.flags = flags;
        return this;
    }

    public DesignRep putFlagsItem(String key, FlagRep flagsItem) {
        if (this.flags == null) {
            this.flags = new HashMap<String, FlagRep>();
        }
        this.flags.put(key, flagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the flag used in this experiment")
    public Map<String, FlagRep> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, FlagRep> flags) {
        this.flags = flags;
    }

    public DesignRep primaryMetric(DependentMetricOrMetricGroupRep primaryMetric) {
        this.primaryMetric = primaryMetric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DependentMetricOrMetricGroupRep getPrimaryMetric() {
        return this.primaryMetric;
    }

    public void setPrimaryMetric(DependentMetricOrMetricGroupRep primaryMetric) {
        this.primaryMetric = primaryMetric;
    }

    public DesignRep randomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user", value="The unit of randomization for this iteration")
    public String getRandomizationUnit() {
        return this.randomizationUnit;
    }

    public void setRandomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
    }

    public DesignRep treatments(List<TreatmentRep> treatments) {
        this.treatments = treatments;
        return this;
    }

    public DesignRep addTreatmentsItem(TreatmentRep treatmentsItem) {
        if (this.treatments == null) {
            this.treatments = new ArrayList<TreatmentRep>();
        }
        this.treatments.add(treatmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the variations you are testing in the experiment")
    public List<TreatmentRep> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(List<TreatmentRep> treatments) {
        this.treatments = treatments;
    }

    public DesignRep secondaryMetrics(List<MetricV2Rep> secondaryMetrics) {
        this.secondaryMetrics = secondaryMetrics;
        return this;
    }

    public DesignRep addSecondaryMetricsItem(MetricV2Rep secondaryMetricsItem) {
        if (this.secondaryMetrics == null) {
            this.secondaryMetrics = new ArrayList<MetricV2Rep>();
        }
        this.secondaryMetrics.add(secondaryMetricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the secondary metrics for this experiment")
    public List<MetricV2Rep> getSecondaryMetrics() {
        return this.secondaryMetrics;
    }

    public void setSecondaryMetrics(List<MetricV2Rep> secondaryMetrics) {
        this.secondaryMetrics = secondaryMetrics;
    }

    public DesignRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesignRep designRep = (DesignRep)o;
        return Objects.equals(this.hypothesis, designRep.hypothesis) && Objects.equals(this.canReshuffleTraffic, designRep.canReshuffleTraffic) && Objects.equals(this.flags, designRep.flags) && Objects.equals(this.primaryMetric, designRep.primaryMetric) && Objects.equals(this.randomizationUnit, designRep.randomizationUnit) && Objects.equals(this.treatments, designRep.treatments) && Objects.equals(this.secondaryMetrics, designRep.secondaryMetrics) && Objects.equals(this.additionalProperties, designRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hypothesis, this.canReshuffleTraffic, this.flags, this.primaryMetric, this.randomizationUnit, this.treatments, this.secondaryMetrics, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DesignRep {\n");
        sb.append("    hypothesis: ").append(this.toIndentedString(this.hypothesis)).append("\n");
        sb.append("    canReshuffleTraffic: ").append(this.toIndentedString(this.canReshuffleTraffic)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    primaryMetric: ").append(this.toIndentedString(this.primaryMetric)).append("\n");
        sb.append("    randomizationUnit: ").append(this.toIndentedString(this.randomizationUnit)).append("\n");
        sb.append("    treatments: ").append(this.toIndentedString(this.treatments)).append("\n");
        sb.append("    secondaryMetrics: ").append(this.toIndentedString(this.secondaryMetrics)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysecondaryMetrics;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DesignRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HYPOTHESIS) != null && !jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hypothesis` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_METRIC) != null) {
            DependentMetricOrMetricGroupRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_METRIC));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).toString()));
        }
        JsonArray jsonArraytreatments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENTS);
        if (jsonArraytreatments != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TREATMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `treatments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENTS).toString()));
            }
            for (int i = 0; i < jsonArraytreatments.size(); ++i) {
                TreatmentRep.validateJsonObject(jsonArraytreatments.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraysecondaryMetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `secondaryMetrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraysecondaryMetrics.size(); ++i) {
                MetricV2Rep.validateJsonObject(jsonArraysecondaryMetrics.get(i).getAsJsonObject());
            }
        }
    }

    public static DesignRep fromJson(String jsonString) throws IOException {
        return (DesignRep)JSON.getGson().fromJson(jsonString, DesignRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HYPOTHESIS);
        openapiFields.add(SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC);
        openapiFields.add(SERIALIZED_NAME_FLAGS);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_METRIC);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNIT);
        openapiFields.add(SERIALIZED_NAME_TREATMENTS);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_METRICS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HYPOTHESIS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!DesignRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DesignRep.class));
            return new TypeAdapter<DesignRep>(){

                public void write(JsonWriter out, DesignRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public DesignRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DesignRep.validateJsonObject(jsonObj);
                    DesignRep instance = (DesignRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

