/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ApprovalSettings;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Environment {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_API_KEY = "apiKey";
    @SerializedName(value="apiKey")
    private String apiKey;
    public static final String SERIALIZED_NAME_MOBILE_KEY = "mobileKey";
    @SerializedName(value="mobileKey")
    private String mobileKey;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color;
    public static final String SERIALIZED_NAME_DEFAULT_TTL = "defaultTtl";
    @SerializedName(value="defaultTtl")
    private Integer defaultTtl;
    public static final String SERIALIZED_NAME_SECURE_MODE = "secureMode";
    @SerializedName(value="secureMode")
    private Boolean secureMode;
    public static final String SERIALIZED_NAME_DEFAULT_TRACK_EVENTS = "defaultTrackEvents";
    @SerializedName(value="defaultTrackEvents")
    private Boolean defaultTrackEvents;
    public static final String SERIALIZED_NAME_REQUIRE_COMMENTS = "requireComments";
    @SerializedName(value="requireComments")
    private Boolean requireComments;
    public static final String SERIALIZED_NAME_CONFIRM_CHANGES = "confirmChanges";
    @SerializedName(value="confirmChanges")
    private Boolean confirmChanges;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_APPROVAL_SETTINGS = "approvalSettings";
    @SerializedName(value="approvalSettings")
    private ApprovalSettings approvalSettings;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Environment links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Environment putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"self\":{\"href\":\"/api/v2/projects/my-project/environments/my-environment\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Environment id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="57be1db38b75bf0772d11384", required=true, value="The ID for the environment. Use this as the client-side ID for authorization in some client-side SDKs, and to associate LaunchDarkly environments with CDN integrations in edge SDKs.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Environment key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="environment-key-123abc", required=true, value="A project-unique key for the new environment")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Environment name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Environment", required=true, value="A human-friendly name for the new environment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Environment apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sdk-xxx", required=true, value="The SDK key for the environment. Use this for authorization in server-side SDKs.")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Environment mobileKey(String mobileKey) {
        this.mobileKey = mobileKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="mob-xxx", required=true, value="The mobile key for the environment. Use this for authorization in mobile SDKs.")
    public String getMobileKey() {
        return this.mobileKey;
    }

    public void setMobileKey(String mobileKey) {
        this.mobileKey = mobileKey;
    }

    public Environment color(String color) {
        this.color = color;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="F5A623", required=true, value="The color used to indicate this environment in the UI")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Environment defaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="5", required=true, value="The default time (in minutes) that the PHP SDK can cache feature flag rules locally")
    public Integer getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public Environment secureMode(Boolean secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Ensures that one end user of the client-side SDK cannot inspect the variations for another end user")
    public Boolean getSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(Boolean secureMode) {
        this.secureMode = secureMode;
    }

    public Environment defaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Enables tracking detailed information for new flags by default")
    public Boolean getDefaultTrackEvents() {
        return this.defaultTrackEvents;
    }

    public void setDefaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
    }

    public Environment requireComments(Boolean requireComments) {
        this.requireComments = requireComments;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether members who modify flags and segments through the LaunchDarkly user interface are required to add a comment")
    public Boolean getRequireComments() {
        return this.requireComments;
    }

    public void setRequireComments(Boolean requireComments) {
        this.requireComments = requireComments;
    }

    public Environment confirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether members who modify flags and segments through the LaunchDarkly user interface are required to confirm those changes")
    public Boolean getConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
    }

    public Environment tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Environment addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"ops\"]", required=true, value="A list of tags for this environment")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Environment approvalSettings(ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApprovalSettings getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public Environment putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment environment = (Environment)o;
        return Objects.equals(this.links, environment.links) && Objects.equals(this.id, environment.id) && Objects.equals(this.key, environment.key) && Objects.equals(this.name, environment.name) && Objects.equals(this.apiKey, environment.apiKey) && Objects.equals(this.mobileKey, environment.mobileKey) && Objects.equals(this.color, environment.color) && Objects.equals(this.defaultTtl, environment.defaultTtl) && Objects.equals(this.secureMode, environment.secureMode) && Objects.equals(this.defaultTrackEvents, environment.defaultTrackEvents) && Objects.equals(this.requireComments, environment.requireComments) && Objects.equals(this.confirmChanges, environment.confirmChanges) && Objects.equals(this.tags, environment.tags) && Objects.equals(this.approvalSettings, environment.approvalSettings) && Objects.equals(this.additionalProperties, environment.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.key, this.name, this.apiKey, this.mobileKey, this.color, this.defaultTtl, this.secureMode, this.defaultTrackEvents, this.requireComments, this.confirmChanges, this.tags, this.approvalSettings, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Environment {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    mobileKey: ").append(this.toIndentedString(this.mobileKey)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    secureMode: ").append(this.toIndentedString(this.secureMode)).append("\n");
        sb.append("    defaultTrackEvents: ").append(this.toIndentedString(this.defaultTrackEvents)).append("\n");
        sb.append("    requireComments: ").append(this.toIndentedString(this.requireComments)).append("\n");
        sb.append("    confirmChanges: ").append(this.toIndentedString(this.confirmChanges)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    approvalSettings: ").append(this.toIndentedString(this.approvalSettings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Environment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_KEY) != null && !jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOBILE_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MOBILE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mobileKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOBILE_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COLOR) != null && !jsonObj.get(SERIALIZED_NAME_COLOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `color` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COLOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPROVAL_SETTINGS) != null) {
            ApprovalSettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPROVAL_SETTINGS));
        }
    }

    public static Environment fromJson(String jsonString) throws IOException {
        return (Environment)JSON.getGson().fromJson(jsonString, Environment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_API_KEY);
        openapiFields.add(SERIALIZED_NAME_MOBILE_KEY);
        openapiFields.add(SERIALIZED_NAME_COLOR);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_TTL);
        openapiFields.add(SERIALIZED_NAME_SECURE_MODE);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_TRACK_EVENTS);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_COMMENTS);
        openapiFields.add(SERIALIZED_NAME_CONFIRM_CHANGES);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_APPROVAL_SETTINGS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_API_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_MOBILE_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_COLOR);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_TTL);
        openapiRequiredFields.add(SERIALIZED_NAME_SECURE_MODE);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_TRACK_EVENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRE_COMMENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_CONFIRM_CHANGES);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Environment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Environment.class));
            return new TypeAdapter<Environment>(){

                public void write(JsonWriter out, Environment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Environment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Environment.validateJsonObject(jsonObj);
                    Environment instance = (Environment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

