/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.SourceEnv;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnvironmentPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color;
    public static final String SERIALIZED_NAME_DEFAULT_TTL = "defaultTtl";
    @SerializedName(value="defaultTtl")
    private Integer defaultTtl;
    public static final String SERIALIZED_NAME_SECURE_MODE = "secureMode";
    @SerializedName(value="secureMode")
    private Boolean secureMode;
    public static final String SERIALIZED_NAME_DEFAULT_TRACK_EVENTS = "defaultTrackEvents";
    @SerializedName(value="defaultTrackEvents")
    private Boolean defaultTrackEvents;
    public static final String SERIALIZED_NAME_CONFIRM_CHANGES = "confirmChanges";
    @SerializedName(value="confirmChanges")
    private Boolean confirmChanges;
    public static final String SERIALIZED_NAME_REQUIRE_COMMENTS = "requireComments";
    @SerializedName(value="requireComments")
    private Boolean requireComments;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private SourceEnv source;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EnvironmentPost name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Environment", required=true, value="A human-friendly name for the new environment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnvironmentPost key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="environment-key-123abc", required=true, value="A project-unique key for the new environment")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public EnvironmentPost color(String color) {
        this.color = color;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="F5A623", required=true, value="A color to indicate this environment in the UI")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public EnvironmentPost defaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="The default time (in minutes) that the PHP SDK can cache feature flag rules locally")
    public Integer getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public EnvironmentPost secureMode(Boolean secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Ensures that one end user of the client-side SDK cannot inspect the variations for another end user")
    public Boolean getSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(Boolean secureMode) {
        this.secureMode = secureMode;
    }

    public EnvironmentPost defaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Enables tracking detailed information for new flags by default")
    public Boolean getDefaultTrackEvents() {
        return this.defaultTrackEvents;
    }

    public void setDefaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
    }

    public EnvironmentPost confirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Requires confirmation for all flag and segment changes via the UI in this environment")
    public Boolean getConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
    }

    public EnvironmentPost requireComments(Boolean requireComments) {
        this.requireComments = requireComments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Requires comments for all flag and segment changes via the UI in this environment")
    public Boolean getRequireComments() {
        return this.requireComments;
    }

    public void setRequireComments(Boolean requireComments) {
        this.requireComments = requireComments;
    }

    public EnvironmentPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EnvironmentPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"ops\"]", value="Tags to apply to the new environment")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public EnvironmentPost source(SourceEnv source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SourceEnv getSource() {
        return this.source;
    }

    public void setSource(SourceEnv source) {
        this.source = source;
    }

    public EnvironmentPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentPost environmentPost = (EnvironmentPost)o;
        return Objects.equals(this.name, environmentPost.name) && Objects.equals(this.key, environmentPost.key) && Objects.equals(this.color, environmentPost.color) && Objects.equals(this.defaultTtl, environmentPost.defaultTtl) && Objects.equals(this.secureMode, environmentPost.secureMode) && Objects.equals(this.defaultTrackEvents, environmentPost.defaultTrackEvents) && Objects.equals(this.confirmChanges, environmentPost.confirmChanges) && Objects.equals(this.requireComments, environmentPost.requireComments) && Objects.equals(this.tags, environmentPost.tags) && Objects.equals(this.source, environmentPost.source) && Objects.equals(this.additionalProperties, environmentPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.color, this.defaultTtl, this.secureMode, this.defaultTrackEvents, this.confirmChanges, this.requireComments, this.tags, this.source, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvironmentPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    secureMode: ").append(this.toIndentedString(this.secureMode)).append("\n");
        sb.append("    defaultTrackEvents: ").append(this.toIndentedString(this.defaultTrackEvents)).append("\n");
        sb.append("    confirmChanges: ").append(this.toIndentedString(this.confirmChanges)).append("\n");
        sb.append("    requireComments: ").append(this.toIndentedString(this.requireComments)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EnvironmentPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COLOR) != null && !jsonObj.get(SERIALIZED_NAME_COLOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `color` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COLOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE) != null) {
            SourceEnv.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE));
        }
    }

    public static EnvironmentPost fromJson(String jsonString) throws IOException {
        return (EnvironmentPost)JSON.getGson().fromJson(jsonString, EnvironmentPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_COLOR);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_TTL);
        openapiFields.add(SERIALIZED_NAME_SECURE_MODE);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_TRACK_EVENTS);
        openapiFields.add(SERIALIZED_NAME_CONFIRM_CHANGES);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_COMMENTS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_COLOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!EnvironmentPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EnvironmentPost.class));
            return new TypeAdapter<EnvironmentPost>(){

                public void write(JsonWriter out, EnvironmentPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public EnvironmentPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EnvironmentPost.validateJsonObject(jsonObj);
                    EnvironmentPost instance = (EnvironmentPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

