/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ApprovalSettings;
import com.launchdarkly.api.model.Conflict;
import com.launchdarkly.api.model.CopiedFromEnv;
import com.launchdarkly.api.model.CustomWorkflowMeta;
import com.launchdarkly.api.model.Environment;
import com.launchdarkly.api.model.ExpandedFlagRep;
import com.launchdarkly.api.model.IntegrationMetadata;
import com.launchdarkly.api.model.Project;
import com.launchdarkly.api.model.ReviewResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpandableApprovalRequestResponse {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_SERVICE_KIND = "serviceKind";
    @SerializedName(value="serviceKind")
    private String serviceKind;
    public static final String SERIALIZED_NAME_REQUESTOR_ID = "requestorId";
    @SerializedName(value="requestorId")
    private String requestorId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_REVIEW_STATUS = "reviewStatus";
    @SerializedName(value="reviewStatus")
    private ReviewStatusEnum reviewStatus;
    public static final String SERIALIZED_NAME_ALL_REVIEWS = "allReviews";
    @SerializedName(value="allReviews")
    private List<ReviewResponse> allReviews = new ArrayList<ReviewResponse>();
    public static final String SERIALIZED_NAME_NOTIFY_MEMBER_IDS = "notifyMemberIds";
    @SerializedName(value="notifyMemberIds")
    private List<String> notifyMemberIds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_APPLIED_DATE = "appliedDate";
    @SerializedName(value="appliedDate")
    private Long appliedDate;
    public static final String SERIALIZED_NAME_APPLIED_BY_MEMBER_ID = "appliedByMemberId";
    @SerializedName(value="appliedByMemberId")
    private String appliedByMemberId;
    public static final String SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID = "appliedByServiceTokenId";
    @SerializedName(value="appliedByServiceTokenId")
    private String appliedByServiceTokenId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
    public static final String SERIALIZED_NAME_CONFLICTS = "conflicts";
    @SerializedName(value="conflicts")
    private List<Conflict> conflicts = new ArrayList<Conflict>();
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Object> links = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_EXECUTION_DATE = "executionDate";
    @SerializedName(value="executionDate")
    private Long executionDate;
    public static final String SERIALIZED_NAME_OPERATING_ON_ID = "operatingOnId";
    @SerializedName(value="operatingOnId")
    private String operatingOnId;
    public static final String SERIALIZED_NAME_INTEGRATION_METADATA = "integrationMetadata";
    @SerializedName(value="integrationMetadata")
    private IntegrationMetadata integrationMetadata;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private CopiedFromEnv source;
    public static final String SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA = "customWorkflowMetadata";
    @SerializedName(value="customWorkflowMetadata")
    private CustomWorkflowMeta customWorkflowMetadata;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    private String resourceId;
    public static final String SERIALIZED_NAME_APPROVAL_SETTINGS = "approvalSettings";
    @SerializedName(value="approvalSettings")
    private ApprovalSettings approvalSettings;
    public static final String SERIALIZED_NAME_PROJECT = "project";
    @SerializedName(value="project")
    private Project project;
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    private List<Environment> environments = null;
    public static final String SERIALIZED_NAME_FLAG = "flag";
    @SerializedName(value="flag")
    private ExpandedFlagRep flag;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExpandableApprovalRequestResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12ab3c45de678910abc12345", required=true, value="The ID of this approval request")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExpandableApprovalRequestResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Version of the approval request")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ExpandableApprovalRequestResponse creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public ExpandableApprovalRequestResponse serviceKind(String serviceKind) {
        this.serviceKind = serviceKind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(String serviceKind) {
        this.serviceKind = serviceKind;
    }

    public ExpandableApprovalRequestResponse requestorId(String requestorId) {
        this.requestorId = requestorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910abc12345", value="The ID of the member who requested the approval")
    public String getRequestorId() {
        return this.requestorId;
    }

    public void setRequestorId(String requestorId) {
        this.requestorId = requestorId;
    }

    public ExpandableApprovalRequestResponse description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="example: request approval from someone", value="A human-friendly name for the approval request")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExpandableApprovalRequestResponse reviewStatus(ReviewStatusEnum reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="pending", required=true, value="Current status of the review of this approval request")
    public ReviewStatusEnum getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(ReviewStatusEnum reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public ExpandableApprovalRequestResponse allReviews(List<ReviewResponse> allReviews) {
        this.allReviews = allReviews;
        return this;
    }

    public ExpandableApprovalRequestResponse addAllReviewsItem(ReviewResponse allReviewsItem) {
        this.allReviews.add(allReviewsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="An array of individual reviews of this approval request")
    public List<ReviewResponse> getAllReviews() {
        return this.allReviews;
    }

    public void setAllReviews(List<ReviewResponse> allReviews) {
        this.allReviews = allReviews;
    }

    public ExpandableApprovalRequestResponse notifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
        return this;
    }

    public ExpandableApprovalRequestResponse addNotifyMemberIdsItem(String notifyMemberIdsItem) {
        this.notifyMemberIds.add(notifyMemberIdsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"1234a56b7c89d012345e678f\"]", required=true, value="An array of member IDs. These members are notified to review the approval request.")
    public List<String> getNotifyMemberIds() {
        return this.notifyMemberIds;
    }

    public void setNotifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
    }

    public ExpandableApprovalRequestResponse appliedDate(Long appliedDate) {
        this.appliedDate = appliedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getAppliedDate() {
        return this.appliedDate;
    }

    public void setAppliedDate(Long appliedDate) {
        this.appliedDate = appliedDate;
    }

    public ExpandableApprovalRequestResponse appliedByMemberId(String appliedByMemberId) {
        this.appliedByMemberId = appliedByMemberId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234a56b7c89d012345e678f", value="The member ID of the member who applied the approval request")
    public String getAppliedByMemberId() {
        return this.appliedByMemberId;
    }

    public void setAppliedByMemberId(String appliedByMemberId) {
        this.appliedByMemberId = appliedByMemberId;
    }

    public ExpandableApprovalRequestResponse appliedByServiceTokenId(String appliedByServiceTokenId) {
        this.appliedByServiceTokenId = appliedByServiceTokenId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234a56b7c89d012345e678f", value="The service token ID of the service token which applied the approval request")
    public String getAppliedByServiceTokenId() {
        return this.appliedByServiceTokenId;
    }

    public void setAppliedByServiceTokenId(String appliedByServiceTokenId) {
        this.appliedByServiceTokenId = appliedByServiceTokenId;
    }

    public ExpandableApprovalRequestResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="pending", required=true, value="Current status of the approval request")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ExpandableApprovalRequestResponse instructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
        return this;
    }

    public ExpandableApprovalRequestResponse addInstructionsItem(Map<String, Object> instructionsItem) {
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<Map<String, Object>> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
    }

    public ExpandableApprovalRequestResponse conflicts(List<Conflict> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    public ExpandableApprovalRequestResponse addConflictsItem(Conflict conflictsItem) {
        this.conflicts.add(conflictsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Details on any conflicting approval requests")
    public List<Conflict> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<Conflict> conflicts) {
        this.conflicts = conflicts;
    }

    public ExpandableApprovalRequestResponse links(Map<String, Object> links) {
        this.links = links;
        return this;
    }

    public ExpandableApprovalRequestResponse putLinksItem(String key, Object linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Object> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Object> links) {
        this.links = links;
    }

    public ExpandableApprovalRequestResponse executionDate(Long executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Long executionDate) {
        this.executionDate = executionDate;
    }

    public ExpandableApprovalRequestResponse operatingOnId(String operatingOnId) {
        this.operatingOnId = operatingOnId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910abc12345", value="ID of scheduled change to edit or delete")
    public String getOperatingOnId() {
        return this.operatingOnId;
    }

    public void setOperatingOnId(String operatingOnId) {
        this.operatingOnId = operatingOnId;
    }

    public ExpandableApprovalRequestResponse integrationMetadata(IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IntegrationMetadata getIntegrationMetadata() {
        return this.integrationMetadata;
    }

    public void setIntegrationMetadata(IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
    }

    public ExpandableApprovalRequestResponse source(CopiedFromEnv source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CopiedFromEnv getSource() {
        return this.source;
    }

    public void setSource(CopiedFromEnv source) {
        this.source = source;
    }

    public ExpandableApprovalRequestResponse customWorkflowMetadata(CustomWorkflowMeta customWorkflowMetadata) {
        this.customWorkflowMetadata = customWorkflowMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CustomWorkflowMeta getCustomWorkflowMetadata() {
        return this.customWorkflowMetadata;
    }

    public void setCustomWorkflowMetadata(CustomWorkflowMeta customWorkflowMetadata) {
        this.customWorkflowMetadata = customWorkflowMetadata;
    }

    public ExpandableApprovalRequestResponse resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="String representation of a resource")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ExpandableApprovalRequestResponse approvalSettings(ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApprovalSettings getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public ExpandableApprovalRequestResponse project(Project project) {
        this.project = project;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public ExpandableApprovalRequestResponse environments(List<Environment> environments) {
        this.environments = environments;
        return this;
    }

    public ExpandableApprovalRequestResponse addEnvironmentsItem(Environment environmentsItem) {
        if (this.environments == null) {
            this.environments = new ArrayList<Environment>();
        }
        this.environments.add(environmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of environments the approval impacts")
    public List<Environment> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Environment> environments) {
        this.environments = environments;
    }

    public ExpandableApprovalRequestResponse flag(ExpandedFlagRep flag) {
        this.flag = flag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExpandedFlagRep getFlag() {
        return this.flag;
    }

    public void setFlag(ExpandedFlagRep flag) {
        this.flag = flag;
    }

    public ExpandableApprovalRequestResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandableApprovalRequestResponse expandableApprovalRequestResponse = (ExpandableApprovalRequestResponse)o;
        return Objects.equals(this.id, expandableApprovalRequestResponse.id) && Objects.equals(this.version, expandableApprovalRequestResponse.version) && Objects.equals(this.creationDate, expandableApprovalRequestResponse.creationDate) && Objects.equals(this.serviceKind, expandableApprovalRequestResponse.serviceKind) && Objects.equals(this.requestorId, expandableApprovalRequestResponse.requestorId) && Objects.equals(this.description, expandableApprovalRequestResponse.description) && Objects.equals((Object)this.reviewStatus, (Object)expandableApprovalRequestResponse.reviewStatus) && Objects.equals(this.allReviews, expandableApprovalRequestResponse.allReviews) && Objects.equals(this.notifyMemberIds, expandableApprovalRequestResponse.notifyMemberIds) && Objects.equals(this.appliedDate, expandableApprovalRequestResponse.appliedDate) && Objects.equals(this.appliedByMemberId, expandableApprovalRequestResponse.appliedByMemberId) && Objects.equals(this.appliedByServiceTokenId, expandableApprovalRequestResponse.appliedByServiceTokenId) && Objects.equals((Object)this.status, (Object)expandableApprovalRequestResponse.status) && Objects.equals(this.instructions, expandableApprovalRequestResponse.instructions) && Objects.equals(this.conflicts, expandableApprovalRequestResponse.conflicts) && Objects.equals(this.links, expandableApprovalRequestResponse.links) && Objects.equals(this.executionDate, expandableApprovalRequestResponse.executionDate) && Objects.equals(this.operatingOnId, expandableApprovalRequestResponse.operatingOnId) && Objects.equals(this.integrationMetadata, expandableApprovalRequestResponse.integrationMetadata) && Objects.equals(this.source, expandableApprovalRequestResponse.source) && Objects.equals(this.customWorkflowMetadata, expandableApprovalRequestResponse.customWorkflowMetadata) && Objects.equals(this.resourceId, expandableApprovalRequestResponse.resourceId) && Objects.equals(this.approvalSettings, expandableApprovalRequestResponse.approvalSettings) && Objects.equals(this.project, expandableApprovalRequestResponse.project) && Objects.equals(this.environments, expandableApprovalRequestResponse.environments) && Objects.equals(this.flag, expandableApprovalRequestResponse.flag) && Objects.equals(this.additionalProperties, expandableApprovalRequestResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.creationDate, this.serviceKind, this.requestorId, this.description, this.reviewStatus, this.allReviews, this.notifyMemberIds, this.appliedDate, this.appliedByMemberId, this.appliedByServiceTokenId, this.status, this.instructions, this.conflicts, this.links, this.executionDate, this.operatingOnId, this.integrationMetadata, this.source, this.customWorkflowMetadata, this.resourceId, this.approvalSettings, this.project, this.environments, this.flag, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandableApprovalRequestResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    serviceKind: ").append(this.toIndentedString(this.serviceKind)).append("\n");
        sb.append("    requestorId: ").append(this.toIndentedString(this.requestorId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reviewStatus: ").append(this.toIndentedString((Object)this.reviewStatus)).append("\n");
        sb.append("    allReviews: ").append(this.toIndentedString(this.allReviews)).append("\n");
        sb.append("    notifyMemberIds: ").append(this.toIndentedString(this.notifyMemberIds)).append("\n");
        sb.append("    appliedDate: ").append(this.toIndentedString(this.appliedDate)).append("\n");
        sb.append("    appliedByMemberId: ").append(this.toIndentedString(this.appliedByMemberId)).append("\n");
        sb.append("    appliedByServiceTokenId: ").append(this.toIndentedString(this.appliedByServiceTokenId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    conflicts: ").append(this.toIndentedString(this.conflicts)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    operatingOnId: ").append(this.toIndentedString(this.operatingOnId)).append("\n");
        sb.append("    integrationMetadata: ").append(this.toIndentedString(this.integrationMetadata)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    customWorkflowMetadata: ").append(this.toIndentedString(this.customWorkflowMetadata)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    approvalSettings: ").append(this.toIndentedString(this.approvalSettings)).append("\n");
        sb.append("    project: ").append(this.toIndentedString(this.project)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    flag: ").append(this.toIndentedString(this.flag)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayenvironments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExpandableApprovalRequestResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_KIND) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `requestorId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reviewStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS).toString()));
        }
        JsonArray jsonArrayallReviews = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALL_REVIEWS);
        if (jsonArrayallReviews != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALL_REVIEWS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allReviews` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALL_REVIEWS).toString()));
            }
            for (int i = 0; i < jsonArrayallReviews.size(); ++i) {
                ReviewResponse.validateJsonObject(jsonArrayallReviews.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifyMemberIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `appliedByMemberId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `appliedByServiceTokenId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `instructions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).toString()));
        }
        JsonArray jsonArrayconflicts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFLICTS);
        if (jsonArrayconflicts != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFLICTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conflicts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFLICTS).toString()));
            }
            for (int i = 0; i < jsonArrayconflicts.size(); ++i) {
                Conflict.validateJsonObject(jsonArrayconflicts.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID) != null && !jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operatingOnId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTEGRATION_METADATA) != null) {
            IntegrationMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTEGRATION_METADATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE) != null) {
            CopiedFromEnv.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA) != null) {
            CustomWorkflowMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPROVAL_SETTINGS) != null) {
            ApprovalSettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPROVAL_SETTINGS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PROJECT) != null) {
            Project.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PROJECT));
        }
        if ((jsonArrayenvironments = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENVIRONMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENVIRONMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `environments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayenvironments.size(); ++i) {
                Environment.validateJsonObject(jsonArrayenvironments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FLAG) != null) {
            ExpandedFlagRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FLAG));
        }
    }

    public static ExpandableApprovalRequestResponse fromJson(String jsonString) throws IOException {
        return (ExpandableApprovalRequestResponse)JSON.getGson().fromJson(jsonString, ExpandableApprovalRequestResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_SERVICE_KIND);
        openapiFields.add(SERIALIZED_NAME_REQUESTOR_ID);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_REVIEW_STATUS);
        openapiFields.add(SERIALIZED_NAME_ALL_REVIEWS);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_MEMBER_IDS);
        openapiFields.add(SERIALIZED_NAME_APPLIED_DATE);
        openapiFields.add(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID);
        openapiFields.add(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_CONFLICTS);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_EXECUTION_DATE);
        openapiFields.add(SERIALIZED_NAME_OPERATING_ON_ID);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_METADATA);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_ID);
        openapiFields.add(SERIALIZED_NAME_APPROVAL_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_PROJECT);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENTS);
        openapiFields.add(SERIALIZED_NAME_FLAG);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_REVIEW_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_ALL_REVIEWS);
        openapiRequiredFields.add(SERIALIZED_NAME_NOTIFY_MEMBER_IDS);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_INSTRUCTIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_CONFLICTS);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ExpandableApprovalRequestResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExpandableApprovalRequestResponse.class));
            return new TypeAdapter<ExpandableApprovalRequestResponse>(){

                public void write(JsonWriter out, ExpandableApprovalRequestResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ExpandableApprovalRequestResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExpandableApprovalRequestResponse.validateJsonObject(jsonObj);
                    ExpandableApprovalRequestResponse instance = (ExpandableApprovalRequestResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PENDING("pending"),
        COMPLETED("completed"),
        FAILED("failed"),
        SCHEDULED("scheduled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReviewStatusEnum {
        APPROVED("approved"),
        DECLINED("declined"),
        PENDING("pending");

        private String value;

        private ReviewStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReviewStatusEnum fromValue(String value) {
            for (ReviewStatusEnum b : ReviewStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReviewStatusEnum> {
            public void write(JsonWriter jsonWriter, ReviewStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReviewStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReviewStatusEnum.fromValue(value);
            }
        }
    }
}

