/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MetricSeen;
import com.launchdarkly.api.model.TreatmentResultRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExperimentBayesianResultsRep {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_TREATMENT_RESULTS = "treatmentResults";
    @SerializedName(value="treatmentResults")
    private List<TreatmentResultRep> treatmentResults = null;
    public static final String SERIALIZED_NAME_METRIC_SEEN = "metricSeen";
    @SerializedName(value="metricSeen")
    private MetricSeen metricSeen;
    public static final String SERIALIZED_NAME_PROBABILITY_OF_MISMATCH = "probabilityOfMismatch";
    @SerializedName(value="probabilityOfMismatch")
    private BigDecimal probabilityOfMismatch;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExperimentBayesianResultsRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ExperimentBayesianResultsRep putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ExperimentBayesianResultsRep treatmentResults(List<TreatmentResultRep> treatmentResults) {
        this.treatmentResults = treatmentResults;
        return this;
    }

    public ExperimentBayesianResultsRep addTreatmentResultsItem(TreatmentResultRep treatmentResultsItem) {
        if (this.treatmentResults == null) {
            this.treatmentResults = new ArrayList<TreatmentResultRep>();
        }
        this.treatmentResults.add(treatmentResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the results for each treatment")
    public List<TreatmentResultRep> getTreatmentResults() {
        return this.treatmentResults;
    }

    public void setTreatmentResults(List<TreatmentResultRep> treatmentResults) {
        this.treatmentResults = treatmentResults;
    }

    public ExperimentBayesianResultsRep metricSeen(MetricSeen metricSeen) {
        this.metricSeen = metricSeen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MetricSeen getMetricSeen() {
        return this.metricSeen;
    }

    public void setMetricSeen(MetricSeen metricSeen) {
        this.metricSeen = metricSeen;
    }

    public ExperimentBayesianResultsRep probabilityOfMismatch(BigDecimal probabilityOfMismatch) {
        this.probabilityOfMismatch = probabilityOfMismatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.9999999999999738", value="The probability of a Sample Ratio Mismatch")
    public BigDecimal getProbabilityOfMismatch() {
        return this.probabilityOfMismatch;
    }

    public void setProbabilityOfMismatch(BigDecimal probabilityOfMismatch) {
        this.probabilityOfMismatch = probabilityOfMismatch;
    }

    public ExperimentBayesianResultsRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExperimentBayesianResultsRep experimentBayesianResultsRep = (ExperimentBayesianResultsRep)o;
        return Objects.equals(this.links, experimentBayesianResultsRep.links) && Objects.equals(this.treatmentResults, experimentBayesianResultsRep.treatmentResults) && Objects.equals(this.metricSeen, experimentBayesianResultsRep.metricSeen) && Objects.equals(this.probabilityOfMismatch, experimentBayesianResultsRep.probabilityOfMismatch) && Objects.equals(this.additionalProperties, experimentBayesianResultsRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.treatmentResults, this.metricSeen, this.probabilityOfMismatch, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExperimentBayesianResultsRep {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    treatmentResults: ").append(this.toIndentedString(this.treatmentResults)).append("\n");
        sb.append("    metricSeen: ").append(this.toIndentedString(this.metricSeen)).append("\n");
        sb.append("    probabilityOfMismatch: ").append(this.toIndentedString(this.probabilityOfMismatch)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExperimentBayesianResultsRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArraytreatmentResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENT_RESULTS);
        if (jsonArraytreatmentResults != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TREATMENT_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `treatmentResults` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArraytreatmentResults.size(); ++i) {
                TreatmentResultRep.validateJsonObject(jsonArraytreatmentResults.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_METRIC_SEEN) != null) {
            MetricSeen.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METRIC_SEEN));
        }
    }

    public static ExperimentBayesianResultsRep fromJson(String jsonString) throws IOException {
        return (ExperimentBayesianResultsRep)JSON.getGson().fromJson(jsonString, ExperimentBayesianResultsRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_TREATMENT_RESULTS);
        openapiFields.add(SERIALIZED_NAME_METRIC_SEEN);
        openapiFields.add(SERIALIZED_NAME_PROBABILITY_OF_MISMATCH);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ExperimentBayesianResultsRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExperimentBayesianResultsRep.class));
            return new TypeAdapter<ExperimentBayesianResultsRep>(){

                public void write(JsonWriter out, ExperimentBayesianResultsRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ExperimentBayesianResultsRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExperimentBayesianResultsRep.validateJsonObject(jsonObj);
                    ExperimentBayesianResultsRep instance = (ExperimentBayesianResultsRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

