/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.BooleanDefaults;
import com.launchdarkly.api.model.ClientSideAvailability;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class FlagDefaults {
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_TEMPORARY = "temporary";
    @SerializedName(value="temporary")
    private Boolean temporary;
    public static final String SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY = "defaultClientSideAvailability";
    @SerializedName(value="defaultClientSideAvailability")
    private ClientSideAvailability defaultClientSideAvailability;
    public static final String SERIALIZED_NAME_BOOLEAN_DEFAULTS = "booleanDefaults";
    @SerializedName(value="booleanDefaults")
    private BooleanDefaults booleanDefaults;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagDefaults tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FlagDefaults addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"tag-1\",\"tag-2\"]", value="A list of default tags for each flag")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FlagDefaults temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the flag should be temporary by default")
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FlagDefaults defaultClientSideAvailability(ClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ClientSideAvailability getDefaultClientSideAvailability() {
        return this.defaultClientSideAvailability;
    }

    public void setDefaultClientSideAvailability(ClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
    }

    public FlagDefaults booleanDefaults(BooleanDefaults booleanDefaults) {
        this.booleanDefaults = booleanDefaults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BooleanDefaults getBooleanDefaults() {
        return this.booleanDefaults;
    }

    public void setBooleanDefaults(BooleanDefaults booleanDefaults) {
        this.booleanDefaults = booleanDefaults;
    }

    public FlagDefaults putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagDefaults flagDefaults = (FlagDefaults)o;
        return Objects.equals(this.tags, flagDefaults.tags) && Objects.equals(this.temporary, flagDefaults.temporary) && Objects.equals(this.defaultClientSideAvailability, flagDefaults.defaultClientSideAvailability) && Objects.equals(this.booleanDefaults, flagDefaults.booleanDefaults) && Objects.equals(this.additionalProperties, flagDefaults.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.temporary, this.defaultClientSideAvailability, this.booleanDefaults, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagDefaults {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    defaultClientSideAvailability: ").append(this.toIndentedString(this.defaultClientSideAvailability)).append("\n");
        sb.append("    booleanDefaults: ").append(this.toIndentedString(this.booleanDefaults)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagDefaults is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY) != null) {
            ClientSideAvailability.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BOOLEAN_DEFAULTS) != null) {
            BooleanDefaults.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BOOLEAN_DEFAULTS));
        }
    }

    public static FlagDefaults fromJson(String jsonString) throws IOException {
        return (FlagDefaults)JSON.getGson().fromJson(jsonString, FlagDefaults.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_BOOLEAN_DEFAULTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagDefaults.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagDefaults.class));
            return new TypeAdapter<FlagDefaults>(){

                public void write(JsonWriter out, FlagDefaults value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagDefaults read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagDefaults.validateJsonObject(jsonObj);
                    FlagDefaults instance = (FlagDefaults)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

