/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PatchSegmentExpiringTargetInstruction {
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_CONTEXT_KEY = "contextKey";
    @SerializedName(value="contextKey")
    private String contextKey;
    public static final String SERIALIZED_NAME_CONTEXT_KIND = "contextKind";
    @SerializedName(value="contextKind")
    private String contextKind;
    public static final String SERIALIZED_NAME_TARGET_TYPE = "targetType";
    @SerializedName(value="targetType")
    private TargetTypeEnum targetType;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Integer value;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PatchSegmentExpiringTargetInstruction kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="addExpiringTarget", required=true, value="The type of change to make to the context's removal date from this segment")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public PatchSegmentExpiringTargetInstruction contextKey(String contextKey) {
        this.contextKey = contextKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A unique key used to represent the context")
    public String getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    public PatchSegmentExpiringTargetInstruction contextKind(String contextKind) {
        this.contextKind = contextKind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="user", required=true, value="The kind of context")
    public String getContextKind() {
        return this.contextKind;
    }

    public void setContextKind(String contextKind) {
        this.contextKind = contextKind;
    }

    public PatchSegmentExpiringTargetInstruction targetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The segment's target type")
    public TargetTypeEnum getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
    }

    public PatchSegmentExpiringTargetInstruction value(Integer value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1653469200000", value="The time, in Unix milliseconds, when the context should be removed from this segment. Required if <code>kind</code> is <code>addExpiringTarget</code> or <code>updateExpiringTarget</code>.")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public PatchSegmentExpiringTargetInstruction version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The version of the expiring target to update. Optional and only used if <code>kind</code> is <code>updateExpiringTarget</code>. If included, update will fail if version doesn't match current version of the expiring target.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public PatchSegmentExpiringTargetInstruction putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchSegmentExpiringTargetInstruction patchSegmentExpiringTargetInstruction = (PatchSegmentExpiringTargetInstruction)o;
        return Objects.equals((Object)this.kind, (Object)patchSegmentExpiringTargetInstruction.kind) && Objects.equals(this.contextKey, patchSegmentExpiringTargetInstruction.contextKey) && Objects.equals(this.contextKind, patchSegmentExpiringTargetInstruction.contextKind) && Objects.equals((Object)this.targetType, (Object)patchSegmentExpiringTargetInstruction.targetType) && Objects.equals(this.value, patchSegmentExpiringTargetInstruction.value) && Objects.equals(this.version, patchSegmentExpiringTargetInstruction.version) && Objects.equals(this.additionalProperties, patchSegmentExpiringTargetInstruction.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.contextKey, this.contextKind, this.targetType, this.value, this.version, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchSegmentExpiringTargetInstruction {\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    contextKey: ").append(this.toIndentedString(this.contextKey)).append("\n");
        sb.append("    contextKind: ").append(this.toIndentedString(this.contextKind)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString((Object)this.targetType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PatchSegmentExpiringTargetInstruction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTEXT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_CONTEXT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contextKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTEXT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTEXT_KIND) != null && !jsonObj.get(SERIALIZED_NAME_CONTEXT_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contextKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTEXT_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).toString()));
        }
    }

    public static PatchSegmentExpiringTargetInstruction fromJson(String jsonString) throws IOException {
        return (PatchSegmentExpiringTargetInstruction)JSON.getGson().fromJson(jsonString, PatchSegmentExpiringTargetInstruction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_CONTEXT_KEY);
        openapiFields.add(SERIALIZED_NAME_CONTEXT_KIND);
        openapiFields.add(SERIALIZED_NAME_TARGET_TYPE);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTEXT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTEXT_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_TARGET_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PatchSegmentExpiringTargetInstruction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PatchSegmentExpiringTargetInstruction.class));
            return new TypeAdapter<PatchSegmentExpiringTargetInstruction>(){

                public void write(JsonWriter out, PatchSegmentExpiringTargetInstruction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PatchSegmentExpiringTargetInstruction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PatchSegmentExpiringTargetInstruction.validateJsonObject(jsonObj);
                    PatchSegmentExpiringTargetInstruction instance = (PatchSegmentExpiringTargetInstruction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TargetTypeEnum {
        INCLUDED("included"),
        EXCLUDED("excluded");

        private String value;

        private TargetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TargetTypeEnum fromValue(String value) {
            for (TargetTypeEnum b : TargetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TargetTypeEnum> {
            public void write(JsonWriter jsonWriter, TargetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TargetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TargetTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        ADDEXPIRINGTARGET("addExpiringTarget"),
        UPDATEEXPIRINGTARGET("updateExpiringTarget"),
        REMOVEEXPIRINGTARGET("removeExpiringTarget");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

