/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RandomizationUnitInput {
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNIT = "randomizationUnit";
    @SerializedName(value="randomizationUnit")
    private String randomizationUnit;
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    private Boolean _default;
    public static final String SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT = "standardRandomizationUnit";
    @SerializedName(value="standardRandomizationUnit")
    private StandardRandomizationUnitEnum standardRandomizationUnit;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RandomizationUnitInput randomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="user", required=true, value="The unit of randomization. Must match the key of an existing context kind in this project.")
    public String getRandomizationUnit() {
        return this.randomizationUnit;
    }

    public void setRandomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
    }

    public RandomizationUnitInput _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="If true, any experiment iterations created within this project will default to using this randomization unit. A project can only have one default randomization unit.")
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public RandomizationUnitInput standardRandomizationUnit(StandardRandomizationUnitEnum standardRandomizationUnit) {
        this.standardRandomizationUnit = standardRandomizationUnit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="One of LaunchDarkly's fixed set of standard randomization units.")
    public StandardRandomizationUnitEnum getStandardRandomizationUnit() {
        return this.standardRandomizationUnit;
    }

    public void setStandardRandomizationUnit(StandardRandomizationUnitEnum standardRandomizationUnit) {
        this.standardRandomizationUnit = standardRandomizationUnit;
    }

    public RandomizationUnitInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomizationUnitInput randomizationUnitInput = (RandomizationUnitInput)o;
        return Objects.equals(this.randomizationUnit, randomizationUnitInput.randomizationUnit) && Objects.equals(this._default, randomizationUnitInput._default) && Objects.equals((Object)this.standardRandomizationUnit, (Object)randomizationUnitInput.standardRandomizationUnit) && Objects.equals(this.additionalProperties, randomizationUnitInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.randomizationUnit, this._default, this.standardRandomizationUnit, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RandomizationUnitInput {\n");
        sb.append("    randomizationUnit: ").append(this.toIndentedString(this.randomizationUnit)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    standardRandomizationUnit: ").append(this.toIndentedString((Object)this.standardRandomizationUnit)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RandomizationUnitInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `standardRandomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT).toString()));
        }
    }

    public static RandomizationUnitInput fromJson(String jsonString) throws IOException {
        return (RandomizationUnitInput)JSON.getGson().fromJson(jsonString, RandomizationUnitInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNIT);
        openapiFields.add(SERIALIZED_NAME_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RANDOMIZATION_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT);
        openapiRequiredFields.add(SERIALIZED_NAME_STANDARD_RANDOMIZATION_UNIT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RandomizationUnitInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RandomizationUnitInput.class));
            return new TypeAdapter<RandomizationUnitInput>(){

                public void write(JsonWriter out, RandomizationUnitInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RandomizationUnitInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RandomizationUnitInput.validateJsonObject(jsonObj);
                    RandomizationUnitInput instance = (RandomizationUnitInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StandardRandomizationUnitEnum {
        GUEST("guest"),
        GUESTTIME("guestTime"),
        ORGANIZATION("organization"),
        REQUEST("request"),
        USER("user"),
        USERTIME("userTime");

        private String value;

        private StandardRandomizationUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StandardRandomizationUnitEnum fromValue(String value) {
            for (StandardRandomizationUnitEnum b : StandardRandomizationUnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StandardRandomizationUnitEnum> {
            public void write(JsonWriter jsonWriter, StandardRandomizationUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StandardRandomizationUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StandardRandomizationUnitEnum.fromValue(value);
            }
        }
    }
}

