/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StatisticRep {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SOURCE_LINK = "sourceLink";
    @SerializedName(value="sourceLink")
    private String sourceLink;
    public static final String SERIALIZED_NAME_DEFAULT_BRANCH = "defaultBranch";
    @SerializedName(value="defaultBranch")
    private String defaultBranch;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_HUNK_COUNT = "hunkCount";
    @SerializedName(value="hunkCount")
    private Integer hunkCount;
    public static final String SERIALIZED_NAME_FILE_COUNT = "fileCount";
    @SerializedName(value="fileCount")
    private Integer fileCount;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StatisticRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="LaunchDarkly-Docs", required=true, value="The repository name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StatisticRep sourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs", required=true, value="A URL to access the repository")
    public String getSourceLink() {
        return this.sourceLink;
    }

    public void setSourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
    }

    public StatisticRep defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="main", required=true, value="The repository's default branch")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public StatisticRep enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether or not a repository is enabled for code reference scanning")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public StatisticRep version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3", required=true, value="The version of the repository's saved information")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public StatisticRep hunkCount(Integer hunkCount) {
        this.hunkCount = hunkCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of code reference hunks in which the flag appears in this repository")
    public Integer getHunkCount() {
        return this.hunkCount;
    }

    public void setHunkCount(Integer hunkCount) {
        this.hunkCount = hunkCount;
    }

    public StatisticRep fileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of files in which the flag appears in this repository")
    public Integer getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    public StatisticRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public StatisticRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public StatisticRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticRep statisticRep = (StatisticRep)o;
        return Objects.equals(this.name, statisticRep.name) && Objects.equals(this.sourceLink, statisticRep.sourceLink) && Objects.equals(this.defaultBranch, statisticRep.defaultBranch) && Objects.equals(this.enabled, statisticRep.enabled) && Objects.equals(this.version, statisticRep.version) && Objects.equals(this.hunkCount, statisticRep.hunkCount) && Objects.equals(this.fileCount, statisticRep.fileCount) && Objects.equals(this.links, statisticRep.links) && Objects.equals(this.additionalProperties, statisticRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sourceLink, this.defaultBranch, this.enabled, this.version, this.hunkCount, this.fileCount, this.links, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatisticRep {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceLink: ").append(this.toIndentedString(this.sourceLink)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    hunkCount: ").append(this.toIndentedString(this.hunkCount)).append("\n");
        sb.append("    fileCount: ").append(this.toIndentedString(this.fileCount)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StatisticRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_LINK) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultBranch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).toString()));
        }
    }

    public static StatisticRep fromJson(String jsonString) throws IOException {
        return (StatisticRep)JSON.getGson().fromJson(jsonString, StatisticRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SOURCE_LINK);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_BRANCH);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_HUNK_COUNT);
        openapiFields.add(SERIALIZED_NAME_FILE_COUNT);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SOURCE_LINK);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_BRANCH);
        openapiRequiredFields.add(SERIALIZED_NAME_ENABLED);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_HUNK_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_FILE_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StatisticRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StatisticRep.class));
            return new TypeAdapter<StatisticRep>(){

                public void write(JsonWriter out, StatisticRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StatisticRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StatisticRep.validateJsonObject(jsonObj);
                    StatisticRep instance = (StatisticRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

