/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.TeamCustomRoles;
import com.launchdarkly.api.model.TeamMaintainers;
import com.launchdarkly.api.model.TeamMembers;
import com.launchdarkly.api.model.TeamProjects;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Team {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "_lastModified";
    @SerializedName(value="_lastModified")
    private Long lastModified;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_IDP_SYNCED = "_idpSynced";
    @SerializedName(value="_idpSynced")
    private Boolean idpSynced;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private TeamCustomRoles roles;
    public static final String SERIALIZED_NAME_MEMBERS = "members";
    @SerializedName(value="members")
    private TeamMembers members;
    public static final String SERIALIZED_NAME_PROJECTS = "projects";
    @SerializedName(value="projects")
    private TeamProjects projects;
    public static final String SERIALIZED_NAME_MAINTAINERS = "maintainers";
    @SerializedName(value="maintainers")
    private TeamMaintainers maintainers;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Team description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Description for this team.", value="A description of the team")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Team key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="team-key-123abc", value="The team key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Team name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example team", value="A human-friendly name for the team")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Team access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public Team creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Team links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Team putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/teams\",\"type\":\"application/json\"},\"roles\":{\"href\":\"/api/v2/teams/example-team/roles\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/teams/example-team\",\"type\":\"application/json\"}}", value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Team lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Team version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="The team version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Team idpSynced(Boolean idpSynced) {
        this.idpSynced = idpSynced;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the team has been synced with an external identity provider (IdP). Team sync is available to customers on an Enterprise plan.")
    public Boolean getIdpSynced() {
        return this.idpSynced;
    }

    public void setIdpSynced(Boolean idpSynced) {
        this.idpSynced = idpSynced;
    }

    public Team roles(TeamCustomRoles roles) {
        this.roles = roles;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TeamCustomRoles getRoles() {
        return this.roles;
    }

    public void setRoles(TeamCustomRoles roles) {
        this.roles = roles;
    }

    public Team members(TeamMembers members) {
        this.members = members;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TeamMembers getMembers() {
        return this.members;
    }

    public void setMembers(TeamMembers members) {
        this.members = members;
    }

    public Team projects(TeamProjects projects) {
        this.projects = projects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TeamProjects getProjects() {
        return this.projects;
    }

    public void setProjects(TeamProjects projects) {
        this.projects = projects;
    }

    public Team maintainers(TeamMaintainers maintainers) {
        this.maintainers = maintainers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TeamMaintainers getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(TeamMaintainers maintainers) {
        this.maintainers = maintainers;
    }

    public Team putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return Objects.equals(this.description, team.description) && Objects.equals(this.key, team.key) && Objects.equals(this.name, team.name) && Objects.equals(this.access, team.access) && Objects.equals(this.creationDate, team.creationDate) && Objects.equals(this.links, team.links) && Objects.equals(this.lastModified, team.lastModified) && Objects.equals(this.version, team.version) && Objects.equals(this.idpSynced, team.idpSynced) && Objects.equals(this.roles, team.roles) && Objects.equals(this.members, team.members) && Objects.equals(this.projects, team.projects) && Objects.equals(this.maintainers, team.maintainers) && Objects.equals(this.additionalProperties, team.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.key, this.name, this.access, this.creationDate, this.links, this.lastModified, this.version, this.idpSynced, this.roles, this.members, this.projects, this.maintainers, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Team {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    idpSynced: ").append(this.toIndentedString(this.idpSynced)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    maintainers: ").append(this.toIndentedString(this.maintainers)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Team is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ROLES) != null) {
            TeamCustomRoles.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ROLES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBERS) != null) {
            TeamMembers.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBERS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PROJECTS) != null) {
            TeamProjects.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PROJECTS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINERS) != null) {
            TeamMaintainers.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINERS));
        }
    }

    public static Team fromJson(String jsonString) throws IOException {
        return (Team)JSON.getGson().fromJson(jsonString, Team.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_IDP_SYNCED);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_MEMBERS);
        openapiFields.add(SERIALIZED_NAME_PROJECTS);
        openapiFields.add(SERIALIZED_NAME_MAINTAINERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Team.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Team.class));
            return new TypeAdapter<Team>(){

                public void write(JsonWriter out, Team value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Team read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Team.validateJsonObject(jsonObj);
                    Team instance = (Team)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

