/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.CredibleIntervalRep;
import com.launchdarkly.api.model.Distribution;
import com.launchdarkly.api.model.RelativeDifferenceRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TreatmentResultRep {
    public static final String SERIALIZED_NAME_TREATMENT_ID = "treatmentId";
    @SerializedName(value="treatmentId")
    private String treatmentId;
    public static final String SERIALIZED_NAME_TREATMENT_NAME = "treatmentName";
    @SerializedName(value="treatmentName")
    private String treatmentName;
    public static final String SERIALIZED_NAME_MEAN = "mean";
    @SerializedName(value="mean")
    private BigDecimal mean;
    public static final String SERIALIZED_NAME_CREDIBLE_INTERVAL = "credibleInterval";
    @SerializedName(value="credibleInterval")
    private CredibleIntervalRep credibleInterval;
    public static final String SERIALIZED_NAME_P_BEST = "pBest";
    @SerializedName(value="pBest")
    private BigDecimal pBest;
    public static final String SERIALIZED_NAME_RELATIVE_DIFFERENCES = "relativeDifferences";
    @SerializedName(value="relativeDifferences")
    private List<RelativeDifferenceRep> relativeDifferences = null;
    public static final String SERIALIZED_NAME_UNITS = "units";
    @SerializedName(value="units")
    private Long units;
    public static final String SERIALIZED_NAME_DISTRIBUTION = "distribution";
    @SerializedName(value="distribution")
    private Distribution distribution;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TreatmentResultRep treatmentId(String treatmentId) {
        this.treatmentId = treatmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="92b8354e-360e-4d67-8f13-fa6a46ca8077", value="The ID of the treatment")
    public String getTreatmentId() {
        return this.treatmentId;
    }

    public void setTreatmentId(String treatmentId) {
        this.treatmentId = treatmentId;
    }

    public TreatmentResultRep treatmentName(String treatmentName) {
        this.treatmentName = treatmentName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="variation 25% off", value="The name of the treatment")
    public String getTreatmentName() {
        return this.treatmentName;
    }

    public void setTreatmentName(String treatmentName) {
        this.treatmentName = treatmentName;
    }

    public TreatmentResultRep mean(BigDecimal mean) {
        this.mean = mean;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.5432525951557093", value="The average value of the variation in this sample. It doesn\u2019t capture the uncertainty in the measurement, so it should not be the only measurement you use to make decisions.")
    public BigDecimal getMean() {
        return this.mean;
    }

    public void setMean(BigDecimal mean) {
        this.mean = mean;
    }

    public TreatmentResultRep credibleInterval(CredibleIntervalRep credibleInterval) {
        this.credibleInterval = credibleInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CredibleIntervalRep getCredibleInterval() {
        return this.credibleInterval;
    }

    public void setCredibleInterval(CredibleIntervalRep credibleInterval) {
        this.credibleInterval = credibleInterval;
    }

    public TreatmentResultRep pBest(BigDecimal pBest) {
        this.pBest = pBest;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.6083", value="The likelihood that this variation has the biggest effect on the primary metric. The variation with the highest probability is likely the best of the variations you're testing")
    public BigDecimal getpBest() {
        return this.pBest;
    }

    public void setpBest(BigDecimal pBest) {
        this.pBest = pBest;
    }

    public TreatmentResultRep relativeDifferences(List<RelativeDifferenceRep> relativeDifferences) {
        this.relativeDifferences = relativeDifferences;
        return this;
    }

    public TreatmentResultRep addRelativeDifferencesItem(RelativeDifferenceRep relativeDifferencesItem) {
        if (this.relativeDifferences == null) {
            this.relativeDifferences = new ArrayList<RelativeDifferenceRep>();
        }
        this.relativeDifferences.add(relativeDifferencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"fromTreatmentId\":\"92b8354e-360e-4d67-8f13-fa6a46ca8077\",\"lower\":-0.13708601934659803,\"upper\":0.42655970355712425}]", value="Estimates of the relative difference between this treatment's mean and the mean of each other treatment")
    public List<RelativeDifferenceRep> getRelativeDifferences() {
        return this.relativeDifferences;
    }

    public void setRelativeDifferences(List<RelativeDifferenceRep> relativeDifferences) {
        this.relativeDifferences = relativeDifferences;
    }

    public TreatmentResultRep units(Long units) {
        this.units = units;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="76", value="The number of end users in this variation of the experiment")
    public Long getUnits() {
        return this.units;
    }

    public void setUnits(Long units) {
        this.units = units;
    }

    public TreatmentResultRep distribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public TreatmentResultRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreatmentResultRep treatmentResultRep = (TreatmentResultRep)o;
        return Objects.equals(this.treatmentId, treatmentResultRep.treatmentId) && Objects.equals(this.treatmentName, treatmentResultRep.treatmentName) && Objects.equals(this.mean, treatmentResultRep.mean) && Objects.equals(this.credibleInterval, treatmentResultRep.credibleInterval) && Objects.equals(this.pBest, treatmentResultRep.pBest) && Objects.equals(this.relativeDifferences, treatmentResultRep.relativeDifferences) && Objects.equals(this.units, treatmentResultRep.units) && Objects.equals(this.distribution, treatmentResultRep.distribution) && Objects.equals(this.additionalProperties, treatmentResultRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.treatmentId, this.treatmentName, this.mean, this.credibleInterval, this.pBest, this.relativeDifferences, this.units, this.distribution, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreatmentResultRep {\n");
        sb.append("    treatmentId: ").append(this.toIndentedString(this.treatmentId)).append("\n");
        sb.append("    treatmentName: ").append(this.toIndentedString(this.treatmentName)).append("\n");
        sb.append("    mean: ").append(this.toIndentedString(this.mean)).append("\n");
        sb.append("    credibleInterval: ").append(this.toIndentedString(this.credibleInterval)).append("\n");
        sb.append("    pBest: ").append(this.toIndentedString(this.pBest)).append("\n");
        sb.append("    relativeDifferences: ").append(this.toIndentedString(this.relativeDifferences)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("    distribution: ").append(this.toIndentedString(this.distribution)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayrelativeDifferences;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TreatmentResultRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TREATMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TREATMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `treatmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `treatmentName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDIBLE_INTERVAL) != null) {
            CredibleIntervalRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDIBLE_INTERVAL));
        }
        if ((jsonArrayrelativeDifferences = jsonObj.getAsJsonArray(SERIALIZED_NAME_RELATIVE_DIFFERENCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RELATIVE_DIFFERENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `relativeDifferences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELATIVE_DIFFERENCES).toString()));
            }
            for (int i = 0; i < jsonArrayrelativeDifferences.size(); ++i) {
                RelativeDifferenceRep.validateJsonObject(jsonArrayrelativeDifferences.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DISTRIBUTION) != null) {
            Distribution.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DISTRIBUTION));
        }
    }

    public static TreatmentResultRep fromJson(String jsonString) throws IOException {
        return (TreatmentResultRep)JSON.getGson().fromJson(jsonString, TreatmentResultRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TREATMENT_ID);
        openapiFields.add(SERIALIZED_NAME_TREATMENT_NAME);
        openapiFields.add(SERIALIZED_NAME_MEAN);
        openapiFields.add(SERIALIZED_NAME_CREDIBLE_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_P_BEST);
        openapiFields.add(SERIALIZED_NAME_RELATIVE_DIFFERENCES);
        openapiFields.add(SERIALIZED_NAME_UNITS);
        openapiFields.add(SERIALIZED_NAME_DISTRIBUTION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TreatmentResultRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TreatmentResultRep.class));
            return new TypeAdapter<TreatmentResultRep>(){

                public void write(JsonWriter out, TreatmentResultRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TreatmentResultRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TreatmentResultRep.validateJsonObject(jsonObj);
                    TreatmentResultRep instance = (TreatmentResultRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

